/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.codec;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class CodecNotFoundException
extends RuntimeException {
    private final DataType cqlType;
    private final GenericType<?> javaType;

    public CodecNotFoundException(@Nullable DataType cqlType, @Nullable GenericType<?> javaType2) {
        this(String.format("Codec not found for requested operation: [%s <-> %s]", cqlType, javaType2), null, cqlType, javaType2);
    }

    public CodecNotFoundException(@NonNull Throwable cause, @Nullable DataType cqlType, @Nullable GenericType<?> javaType2) {
        this(String.format("Error while looking up codec for requested operation: [%s <-> %s]", cqlType, javaType2), cause, cqlType, javaType2);
    }

    private CodecNotFoundException(String msg, Throwable cause, DataType cqlType, GenericType<?> javaType2) {
        super(msg, cause);
        this.cqlType = cqlType;
        this.javaType = javaType2;
    }

    @Nullable
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Nullable
    public GenericType<?> getJavaType() {
        return this.javaType;
    }
}

