/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metrics;

import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public enum DefaultNodeMetric implements NodeMetric
{
    OPEN_CONNECTIONS("pool.open-connections"),
    AVAILABLE_STREAMS("pool.available-streams"),
    IN_FLIGHT("pool.in-flight"),
    ORPHANED_STREAMS("pool.orphaned-streams"),
    BYTES_SENT("bytes-sent"),
    BYTES_RECEIVED("bytes-received"),
    CQL_MESSAGES("cql-messages"),
    UNSENT_REQUESTS("errors.request.unsent"),
    ABORTED_REQUESTS("errors.request.aborted"),
    WRITE_TIMEOUTS("errors.request.write-timeouts"),
    READ_TIMEOUTS("errors.request.read-timeouts"),
    UNAVAILABLES("errors.request.unavailables"),
    OTHER_ERRORS("errors.request.others"),
    RETRIES("retries.total"),
    RETRIES_ON_ABORTED("retries.aborted"),
    RETRIES_ON_READ_TIMEOUT("retries.read-timeout"),
    RETRIES_ON_WRITE_TIMEOUT("retries.write-timeout"),
    RETRIES_ON_UNAVAILABLE("retries.unavailable"),
    RETRIES_ON_OTHER_ERROR("retries.other"),
    IGNORES("ignores.total"),
    IGNORES_ON_ABORTED("ignores.aborted"),
    IGNORES_ON_READ_TIMEOUT("ignores.read-timeout"),
    IGNORES_ON_WRITE_TIMEOUT("ignores.write-timeout"),
    IGNORES_ON_UNAVAILABLE("ignores.unavailable"),
    IGNORES_ON_OTHER_ERROR("ignores.other"),
    SPECULATIVE_EXECUTIONS("speculative-executions"),
    CONNECTION_INIT_ERRORS("errors.connection.init"),
    AUTHENTICATION_ERRORS("errors.connection.auth");

    private static final Map<String, DefaultNodeMetric> BY_PATH;
    private final String path;

    private DefaultNodeMetric(String path) {
        this.path = path;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public static DefaultNodeMetric fromPath(@NonNull String path) {
        DefaultNodeMetric metric = BY_PATH.get(path);
        if (metric == null) {
            throw new IllegalArgumentException("Unknown node metric path " + path);
        }
        return metric;
    }

    private static Map<String, DefaultNodeMetric> sortByPath() {
        ImmutableMap.Builder<String, DefaultNodeMetric> result2 = ImmutableMap.builder();
        for (DefaultNodeMetric value2 : DefaultNodeMetric.values()) {
            result2.put(value2.getPath(), value2);
        }
        return result2.build();
    }

    static {
        BY_PATH = DefaultNodeMetric.sortByPath();
    }
}

