/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;

public interface TableMetadata
extends RelationMetadata {
    public boolean isCompactStorage();

    public boolean isVirtual();

    @NonNull
    public Map<CqlIdentifier, IndexMetadata> getIndexes();

    @NonNull
    default public Optional<IndexMetadata> getIndex(@NonNull CqlIdentifier indexId) {
        return Optional.ofNullable(this.getIndexes().get(indexId));
    }

    @NonNull
    default public Optional<IndexMetadata> getIndex(@NonNull String indexName) {
        return this.getIndex(CqlIdentifier.fromCql(indexName));
    }

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        if (this.isVirtual()) {
            builder.append("/* VIRTUAL ");
        } else {
            builder.append("CREATE ");
        }
        builder.append("TABLE ").append(this.getKeyspace()).append(".").append(this.getName()).append(" (").newLine().increaseIndent();
        for (ColumnMetadata columnMetadata : this.getColumns().values()) {
            builder.append(columnMetadata.getName()).append(" ").append(columnMetadata.getType().asCql(true, pretty));
            if (columnMetadata.isStatic()) {
                builder.append(" static");
            }
            builder.append(",").newLine();
        }
        builder.append("PRIMARY KEY (");
        if (this.getPartitionKey().size() == 1) {
            builder.append(this.getPartitionKey().get(0).getName());
        } else {
            builder.append("(");
            boolean first = true;
            for (ColumnMetadata pkColumn : this.getPartitionKey()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(pkColumn.getName());
            }
            builder.append(")");
        }
        for (ColumnMetadata columnMetadata : this.getClusteringColumns().keySet()) {
            builder.append(", ").append(columnMetadata.getName());
        }
        builder.append(")");
        builder.newLine().decreaseIndent().append(")");
        builder.increaseIndent();
        if (this.isCompactStorage()) {
            builder.andWith().append("COMPACT STORAGE");
        }
        if (this.getClusteringColumns().containsValue((Object)ClusteringOrder.DESC)) {
            builder.andWith().append("CLUSTERING ORDER BY (");
            boolean first = true;
            for (Map.Entry<ColumnMetadata, ClusteringOrder> entry2 : this.getClusteringColumns().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(entry2.getKey().getName()).append(" ").append(entry2.getValue().name());
            }
            builder.append(")");
        }
        Map<CqlIdentifier, Object> options = this.getOptions();
        RelationParser.appendOptions(options, builder);
        builder.append(";");
        if (this.isVirtual()) {
            builder.append(" */");
        }
        return builder.build();
    }

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        String createTable = this.describe(pretty);
        ScriptBuilder builder = new ScriptBuilder(pretty).append(createTable);
        for (IndexMetadata indexMetadata : this.getIndexes().values()) {
            builder.forceNewLine(2).append(indexMetadata.describeWithChildren(pretty));
        }
        return builder.build();
    }
}

