/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.AccessibleByName;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.SettableByIndex;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface SettableByName<SelfT extends SettableByName<SelfT>>
extends SettableByIndex<SelfT>,
AccessibleByName {
    @NonNull
    @CheckReturnValue
    default public SelfT setBytesUnsafe(@NonNull String name2, @Nullable ByteBuffer v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setBytesUnsafe(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @Override
    @NonNull
    default public DataType getType(@NonNull String name2) {
        return this.getType(this.firstIndexOf(name2));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToNull(@NonNull String name2) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setToNull(i);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name2, @Nullable ValueT v, @NonNull TypeCodec<ValueT> codec) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).set((int)i, v, codec);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name2, @Nullable ValueT v, @NonNull GenericType<ValueT> targetType) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).set((int)i, v, targetType);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public <ValueT> SelfT set(@NonNull String name2, @Nullable ValueT v, @NonNull Class<ValueT> targetClass) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).set((int)i, v, targetClass);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBoolean(@NonNull String name2, boolean v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setBoolean(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @Deprecated
    @NonNull
    @CheckReturnValue
    default public SelfT setBool(@NonNull String name2, boolean v) {
        return this.setBoolean(name2, v);
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByte(@NonNull String name2, byte v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setByte(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setDouble(@NonNull String name2, double v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setDouble(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setFloat(@NonNull String name2, float v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setFloat(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInt(@NonNull String name2, int v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setInt(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLong(@NonNull String name2, long v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setLong(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setShort(@NonNull String name2, short v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setShort(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInstant(@NonNull String name2, @Nullable Instant v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setInstant(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalDate(@NonNull String name2, @Nullable LocalDate v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setLocalDate(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setLocalTime(@NonNull String name2, @Nullable LocalTime v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setLocalTime(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setByteBuffer(@NonNull String name2, @Nullable ByteBuffer v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setByteBuffer(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setString(@NonNull String name2, @Nullable String v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setString(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigInteger(@NonNull String name2, @Nullable BigInteger v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setBigInteger(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setBigDecimal(@NonNull String name2, @Nullable BigDecimal v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setBigDecimal(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUuid(@NonNull String name2, @Nullable UUID v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setUuid(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setInetAddress(@NonNull String name2, @Nullable InetAddress v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setInetAddress(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setCqlDuration(@NonNull String name2, @Nullable CqlDuration v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setCqlDuration(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setToken(@NonNull String name2, @NonNull Token v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setToken(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setList(@NonNull String name2, @Nullable List<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setList(i, v, elementsClass);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public <ElementT> SelfT setSet(@NonNull String name2, @Nullable Set<ElementT> v, @NonNull Class<ElementT> elementsClass) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setSet(i, v, elementsClass);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public <KeyT, ValueT> SelfT setMap(@NonNull String name2, @Nullable Map<KeyT, ValueT> v, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setMap(i, v, keyClass, valueClass);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setUdtValue(@NonNull String name2, @Nullable UdtValue v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setUdtValue(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT setTupleValue(@NonNull String name2, @Nullable TupleValue v) {
        SettableByName result2 = null;
        for (Integer i : this.allIndicesOf(name2)) {
            result2 = (SettableByName)(result2 == null ? this : result2).setTupleValue(i, v);
        }
        if (!1.$assertionsDisabled && result2 == null) {
            throw new AssertionError();
        }
        return (SelfT)result2;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

