/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.data.GettableById;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.detach.Detachable;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface Row
extends GettableByIndex,
GettableByName,
GettableById,
Detachable {
    @NonNull
    public ColumnDefinitions getColumnDefinitions();

    @NonNull
    default public String getFormattedContents() {
        StringBuilder result2 = new StringBuilder("[");
        ColumnDefinitions definitions = this.getColumnDefinitions();
        for (int i = 0; i < definitions.size(); ++i) {
            if (i > 0) {
                result2.append(", ");
            }
            ColumnDefinition definition = definitions.get(i);
            String name2 = definition.getName().asCql(true);
            TypeCodec<DataType> codec = this.codecRegistry().codecFor(definition.getType());
            DataType value2 = codec.decode(this.getBytesUnsafe(i), this.protocolVersion());
            result2.append(name2).append(':').append(codec.format(value2));
        }
        return result2.append("]").toString();
    }

    public String toString();
}

