/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.GettableById;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.SettableById;
import com.datastax.oss.driver.api.core.data.SettableByName;
import com.datastax.oss.protocol.internal.ProtocolConstants;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface Bindable<SelfT extends Bindable<SelfT>>
extends GettableById,
GettableByName,
SettableById<SelfT>,
SettableByName<SelfT> {
    default public boolean isSet(int i) {
        return this.getBytesUnsafe(i) != ProtocolConstants.UNSET_VALUE;
    }

    default public boolean isSet(@NonNull CqlIdentifier id) {
        return this.getBytesUnsafe(id) != ProtocolConstants.UNSET_VALUE;
    }

    default public boolean isSet(@NonNull String name2) {
        return this.getBytesUnsafe(name2) != ProtocolConstants.UNSET_VALUE;
    }

    @NonNull
    @CheckReturnValue
    default public SelfT unset(int i) {
        return (SelfT)((Bindable)this.setBytesUnsafe(i, ProtocolConstants.UNSET_VALUE));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT unset(@NonNull CqlIdentifier id) {
        return (SelfT)((Bindable)this.setBytesUnsafe(id, ProtocolConstants.UNSET_VALUE));
    }

    @NonNull
    @CheckReturnValue
    default public SelfT unset(@NonNull String name2) {
        return (SelfT)((Bindable)this.setBytesUnsafe(name2, ProtocolConstants.UNSET_VALUE));
    }
}

