/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class TypedDriverOption<ValueT> {
    private static volatile Iterable<TypedDriverOption<?>> builtInValues;
    private final DriverOption rawOption;
    private final GenericType<ValueT> expectedType;
    public static final TypedDriverOption<List<String>> CONTACT_POINTS;
    public static final TypedDriverOption<String> SESSION_NAME;
    public static final TypedDriverOption<String> SESSION_KEYSPACE;
    public static final TypedDriverOption<Duration> CONFIG_RELOAD_INTERVAL;
    public static final TypedDriverOption<Duration> REQUEST_TIMEOUT;
    public static final TypedDriverOption<String> REQUEST_CONSISTENCY;
    public static final TypedDriverOption<Integer> REQUEST_PAGE_SIZE;
    public static final TypedDriverOption<String> REQUEST_SERIAL_CONSISTENCY;
    public static final TypedDriverOption<Boolean> REQUEST_DEFAULT_IDEMPOTENCE;
    public static final TypedDriverOption<String> LOAD_BALANCING_POLICY_CLASS;
    public static final TypedDriverOption<String> LOAD_BALANCING_LOCAL_DATACENTER;
    public static final TypedDriverOption<String> LOAD_BALANCING_FILTER_CLASS;
    public static final TypedDriverOption<Duration> CONNECTION_INIT_QUERY_TIMEOUT;
    public static final TypedDriverOption<Duration> CONNECTION_SET_KEYSPACE_TIMEOUT;
    public static final TypedDriverOption<Integer> CONNECTION_MAX_REQUESTS;
    public static final TypedDriverOption<Integer> CONNECTION_MAX_ORPHAN_REQUESTS;
    public static final TypedDriverOption<Boolean> CONNECTION_WARN_INIT_ERROR;
    public static final TypedDriverOption<Integer> CONNECTION_POOL_LOCAL_SIZE;
    public static final TypedDriverOption<Integer> CONNECTION_POOL_REMOTE_SIZE;
    public static final TypedDriverOption<Boolean> RECONNECT_ON_INIT;
    public static final TypedDriverOption<String> RECONNECTION_POLICY_CLASS;
    public static final TypedDriverOption<Duration> RECONNECTION_BASE_DELAY;
    public static final TypedDriverOption<Duration> RECONNECTION_MAX_DELAY;
    public static final TypedDriverOption<String> RETRY_POLICY_CLASS;
    public static final TypedDriverOption<String> SPECULATIVE_EXECUTION_POLICY_CLASS;
    public static final TypedDriverOption<Integer> SPECULATIVE_EXECUTION_MAX;
    public static final TypedDriverOption<Duration> SPECULATIVE_EXECUTION_DELAY;
    public static final TypedDriverOption<String> AUTH_PROVIDER_CLASS;
    public static final TypedDriverOption<String> AUTH_PROVIDER_USER_NAME;
    public static final TypedDriverOption<String> AUTH_PROVIDER_PASSWORD;
    public static final TypedDriverOption<String> SSL_ENGINE_FACTORY_CLASS;
    public static final TypedDriverOption<List<String>> SSL_CIPHER_SUITES;
    public static final TypedDriverOption<Boolean> SSL_HOSTNAME_VALIDATION;
    public static final TypedDriverOption<String> SSL_KEYSTORE_PATH;
    public static final TypedDriverOption<String> SSL_KEYSTORE_PASSWORD;
    public static final TypedDriverOption<String> SSL_TRUSTSTORE_PATH;
    public static final TypedDriverOption<String> SSL_TRUSTSTORE_PASSWORD;
    public static final TypedDriverOption<String> TIMESTAMP_GENERATOR_CLASS;
    public static final TypedDriverOption<Boolean> TIMESTAMP_GENERATOR_FORCE_JAVA_CLOCK;
    public static final TypedDriverOption<Duration> TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD;
    public static final TypedDriverOption<Duration> TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL;
    public static final TypedDriverOption<String> REQUEST_TRACKER_CLASS;
    public static final TypedDriverOption<Boolean> REQUEST_LOGGER_SUCCESS_ENABLED;
    public static final TypedDriverOption<Duration> REQUEST_LOGGER_SLOW_THRESHOLD;
    public static final TypedDriverOption<Boolean> REQUEST_LOGGER_SLOW_ENABLED;
    public static final TypedDriverOption<Boolean> REQUEST_LOGGER_ERROR_ENABLED;
    public static final TypedDriverOption<Integer> REQUEST_LOGGER_MAX_QUERY_LENGTH;
    public static final TypedDriverOption<Boolean> REQUEST_LOGGER_VALUES;
    public static final TypedDriverOption<Integer> REQUEST_LOGGER_MAX_VALUE_LENGTH;
    public static final TypedDriverOption<Integer> REQUEST_LOGGER_MAX_VALUES;
    public static final TypedDriverOption<Boolean> REQUEST_LOGGER_STACK_TRACES;
    public static final TypedDriverOption<String> REQUEST_THROTTLER_CLASS;
    public static final TypedDriverOption<Integer> REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS;
    public static final TypedDriverOption<Integer> REQUEST_THROTTLER_MAX_REQUESTS_PER_SECOND;
    public static final TypedDriverOption<Integer> REQUEST_THROTTLER_MAX_QUEUE_SIZE;
    public static final TypedDriverOption<Duration> REQUEST_THROTTLER_DRAIN_INTERVAL;
    public static final TypedDriverOption<String> METADATA_NODE_STATE_LISTENER_CLASS;
    public static final TypedDriverOption<String> METADATA_SCHEMA_CHANGE_LISTENER_CLASS;
    public static final TypedDriverOption<String> ADDRESS_TRANSLATOR_CLASS;
    public static final TypedDriverOption<String> PROTOCOL_VERSION;
    public static final TypedDriverOption<String> PROTOCOL_COMPRESSION;
    public static final TypedDriverOption<Long> PROTOCOL_MAX_FRAME_LENGTH;
    public static final TypedDriverOption<Boolean> REQUEST_WARN_IF_SET_KEYSPACE;
    public static final TypedDriverOption<Integer> REQUEST_TRACE_ATTEMPTS;
    public static final TypedDriverOption<Duration> REQUEST_TRACE_INTERVAL;
    public static final TypedDriverOption<String> REQUEST_TRACE_CONSISTENCY;
    public static final TypedDriverOption<List<String>> METRICS_SESSION_ENABLED;
    public static final TypedDriverOption<List<String>> METRICS_NODE_ENABLED;
    public static final TypedDriverOption<Duration> METRICS_SESSION_CQL_REQUESTS_HIGHEST;
    public static final TypedDriverOption<Integer> METRICS_SESSION_CQL_REQUESTS_DIGITS;
    public static final TypedDriverOption<Duration> METRICS_SESSION_CQL_REQUESTS_INTERVAL;
    public static final TypedDriverOption<Duration> METRICS_SESSION_THROTTLING_HIGHEST;
    public static final TypedDriverOption<Integer> METRICS_SESSION_THROTTLING_DIGITS;
    public static final TypedDriverOption<Duration> METRICS_SESSION_THROTTLING_INTERVAL;
    public static final TypedDriverOption<Duration> METRICS_NODE_CQL_MESSAGES_HIGHEST;
    public static final TypedDriverOption<Integer> METRICS_NODE_CQL_MESSAGES_DIGITS;
    public static final TypedDriverOption<Duration> METRICS_NODE_CQL_MESSAGES_INTERVAL;
    public static final TypedDriverOption<Boolean> SOCKET_TCP_NODELAY;
    public static final TypedDriverOption<Boolean> SOCKET_KEEP_ALIVE;
    public static final TypedDriverOption<Boolean> SOCKET_REUSE_ADDRESS;
    public static final TypedDriverOption<Integer> SOCKET_LINGER_INTERVAL;
    public static final TypedDriverOption<Integer> SOCKET_RECEIVE_BUFFER_SIZE;
    public static final TypedDriverOption<Integer> SOCKET_SEND_BUFFER_SIZE;
    public static final TypedDriverOption<Duration> HEARTBEAT_INTERVAL;
    public static final TypedDriverOption<Duration> HEARTBEAT_TIMEOUT;
    public static final TypedDriverOption<Duration> METADATA_TOPOLOGY_WINDOW;
    public static final TypedDriverOption<Integer> METADATA_TOPOLOGY_MAX_EVENTS;
    public static final TypedDriverOption<Boolean> METADATA_SCHEMA_ENABLED;
    public static final TypedDriverOption<Duration> METADATA_SCHEMA_REQUEST_TIMEOUT;
    public static final TypedDriverOption<Integer> METADATA_SCHEMA_REQUEST_PAGE_SIZE;
    public static final TypedDriverOption<List<String>> METADATA_SCHEMA_REFRESHED_KEYSPACES;
    public static final TypedDriverOption<Duration> METADATA_SCHEMA_WINDOW;
    public static final TypedDriverOption<Integer> METADATA_SCHEMA_MAX_EVENTS;
    public static final TypedDriverOption<Boolean> METADATA_TOKEN_MAP_ENABLED;
    public static final TypedDriverOption<Duration> CONTROL_CONNECTION_TIMEOUT;
    public static final TypedDriverOption<Duration> CONTROL_CONNECTION_AGREEMENT_INTERVAL;
    public static final TypedDriverOption<Duration> CONTROL_CONNECTION_AGREEMENT_TIMEOUT;
    public static final TypedDriverOption<Boolean> CONTROL_CONNECTION_AGREEMENT_WARN;
    public static final TypedDriverOption<Boolean> PREPARE_ON_ALL_NODES;
    public static final TypedDriverOption<Boolean> REPREPARE_ENABLED;
    public static final TypedDriverOption<Boolean> REPREPARE_CHECK_SYSTEM_TABLE;
    public static final TypedDriverOption<Integer> REPREPARE_MAX_STATEMENTS;
    public static final TypedDriverOption<Integer> REPREPARE_MAX_PARALLELISM;
    public static final TypedDriverOption<Duration> REPREPARE_TIMEOUT;
    public static final TypedDriverOption<Integer> NETTY_IO_SIZE;
    public static final TypedDriverOption<Integer> NETTY_IO_SHUTDOWN_QUIET_PERIOD;
    public static final TypedDriverOption<Integer> NETTY_IO_SHUTDOWN_TIMEOUT;
    public static final TypedDriverOption<String> NETTY_IO_SHUTDOWN_UNIT;
    public static final TypedDriverOption<Integer> NETTY_ADMIN_SIZE;
    public static final TypedDriverOption<Integer> NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD;
    public static final TypedDriverOption<Integer> NETTY_ADMIN_SHUTDOWN_TIMEOUT;
    public static final TypedDriverOption<String> NETTY_ADMIN_SHUTDOWN_UNIT;
    @Deprecated
    public static final TypedDriverOption<Integer> COALESCER_MAX_RUNS;
    public static final TypedDriverOption<Duration> COALESCER_INTERVAL;
    public static final TypedDriverOption<Boolean> RESOLVE_CONTACT_POINTS;
    public static final TypedDriverOption<Duration> NETTY_TIMER_TICK_DURATION;
    public static final TypedDriverOption<Integer> NETTY_TIMER_TICKS_PER_WHEEL;
    public static final TypedDriverOption<Boolean> REQUEST_LOG_WARNINGS;
    public static final TypedDriverOption<Boolean> NETTY_DAEMON;
    public static final TypedDriverOption<String> CLOUD_SECURE_CONNECT_BUNDLE;
    public static final TypedDriverOption<Boolean> LOAD_BALANCING_POLICY_SLOW_AVOIDANCE;
    public static final TypedDriverOption<Duration> CONNECTION_CONNECT_TIMEOUT;
    public static final TypedDriverOption<Integer> SESSION_LEAK_THRESHOLD;
    public static final TypedDriverOption<String> APPLICATION_NAME;
    public static final TypedDriverOption<String> APPLICATION_VERSION;
    public static final TypedDriverOption<String> AUTH_PROVIDER_AUTHORIZATION_ID;
    public static final TypedDriverOption<String> AUTH_PROVIDER_SERVICE;
    public static final TypedDriverOption<String> AUTH_PROVIDER_LOGIN_CONFIGURATION;
    public static final TypedDriverOption<Map<String, String>> AUTH_PROVIDER_SASL_PROPERTIES;
    public static final TypedDriverOption<Integer> CONTINUOUS_PAGING_PAGE_SIZE;
    public static final TypedDriverOption<Boolean> CONTINUOUS_PAGING_PAGE_SIZE_BYTES;
    public static final TypedDriverOption<Integer> CONTINUOUS_PAGING_MAX_PAGES;
    public static final TypedDriverOption<Integer> CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND;
    public static final TypedDriverOption<Integer> CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES;
    public static final TypedDriverOption<Duration> CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE;
    public static final TypedDriverOption<Duration> CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES;
    public static final TypedDriverOption<Duration> CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST;
    public static final TypedDriverOption<Integer> CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS;
    public static final TypedDriverOption<Duration> CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_INTERVAL;
    public static final TypedDriverOption<String> GRAPH_READ_CONSISTENCY_LEVEL;
    public static final TypedDriverOption<String> GRAPH_WRITE_CONSISTENCY_LEVEL;
    public static final TypedDriverOption<String> GRAPH_TRAVERSAL_SOURCE;
    public static final TypedDriverOption<String> GRAPH_SUB_PROTOCOL;
    public static final TypedDriverOption<Boolean> GRAPH_IS_SYSTEM_QUERY;
    public static final TypedDriverOption<String> GRAPH_NAME;
    public static final TypedDriverOption<Duration> GRAPH_TIMEOUT;
    public static final TypedDriverOption<Boolean> MONITOR_REPORTING_ENABLED;
    public static final TypedDriverOption<String> GRAPH_PAGING_ENABLED;
    public static final TypedDriverOption<Integer> GRAPH_CONTINUOUS_PAGING_PAGE_SIZE;
    public static final TypedDriverOption<Integer> GRAPH_CONTINUOUS_PAGING_MAX_PAGES;
    public static final TypedDriverOption<Integer> GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND;
    public static final TypedDriverOption<Integer> GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES;
    public static final TypedDriverOption<Duration> METRICS_SESSION_GRAPH_REQUESTS_HIGHEST;
    public static final TypedDriverOption<Integer> METRICS_SESSION_GRAPH_REQUESTS_DIGITS;
    public static final TypedDriverOption<Duration> METRICS_SESSION_GRAPH_REQUESTS_INTERVAL;
    public static final TypedDriverOption<Duration> METRICS_NODE_GRAPH_MESSAGES_HIGHEST;
    public static final TypedDriverOption<Integer> METRICS_NODE_GRAPH_MESSAGES_DIGITS;
    public static final TypedDriverOption<Duration> METRICS_NODE_GRAPH_MESSAGES_INTERVAL;
    public static final TypedDriverOption<Duration> METRICS_NODE_EXPIRE_AFTER;
    private static final int PUBLIC_STATIC_FINAL = 25;

    public static Iterable<TypedDriverOption<?>> builtInValues() {
        if (builtInValues == null) {
            builtInValues = TypedDriverOption.introspectBuiltInValues();
        }
        return builtInValues;
    }

    public TypedDriverOption(@NonNull DriverOption rawOption, @NonNull GenericType<ValueT> expectedType) {
        this.rawOption = Objects.requireNonNull(rawOption);
        this.expectedType = Objects.requireNonNull(expectedType);
    }

    @NonNull
    public DriverOption getRawOption() {
        return this.rawOption;
    }

    @NonNull
    public GenericType<ValueT> getExpectedType() {
        return this.expectedType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TypedDriverOption) {
            TypedDriverOption that = (TypedDriverOption)other;
            return this.rawOption.equals(that.rawOption) && this.expectedType.equals(that.expectedType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.rawOption, this.expectedType);
    }

    public String toString() {
        return new StringJoiner(", ", TypedDriverOption.class.getSimpleName() + "[", "]").add("rawOption=" + this.rawOption).add("expectedType=" + this.expectedType).toString();
    }

    private static Iterable<TypedDriverOption<?>> introspectBuiltInValues() {
        try {
            ImmutableList.Builder result2 = ImmutableList.builder();
            for (Field field2 : TypedDriverOption.class.getFields()) {
                if ((field2.getModifiers() & 0x19) != 25 || field2.getType() != TypedDriverOption.class) continue;
                TypedDriverOption typedOption = (TypedDriverOption)field2.get(null);
                result2.add(typedOption);
            }
            return result2.build();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected error while introspecting built-in values", e);
        }
    }

    static {
        CONTACT_POINTS = new TypedDriverOption<List<String>>(DefaultDriverOption.CONTACT_POINTS, GenericType.listOf(String.class));
        SESSION_NAME = new TypedDriverOption<String>(DefaultDriverOption.SESSION_NAME, GenericType.STRING);
        SESSION_KEYSPACE = new TypedDriverOption<String>(DefaultDriverOption.SESSION_KEYSPACE, GenericType.STRING);
        CONFIG_RELOAD_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.CONFIG_RELOAD_INTERVAL, GenericType.DURATION);
        REQUEST_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.REQUEST_TIMEOUT, GenericType.DURATION);
        REQUEST_CONSISTENCY = new TypedDriverOption<String>(DefaultDriverOption.REQUEST_CONSISTENCY, GenericType.STRING);
        REQUEST_PAGE_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_PAGE_SIZE, GenericType.INTEGER);
        REQUEST_SERIAL_CONSISTENCY = new TypedDriverOption<String>(DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, GenericType.STRING);
        REQUEST_DEFAULT_IDEMPOTENCE = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, GenericType.BOOLEAN);
        LOAD_BALANCING_POLICY_CLASS = new TypedDriverOption<String>(DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, GenericType.STRING);
        LOAD_BALANCING_LOCAL_DATACENTER = new TypedDriverOption<String>(DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, GenericType.STRING);
        LOAD_BALANCING_FILTER_CLASS = new TypedDriverOption<String>(DefaultDriverOption.LOAD_BALANCING_FILTER_CLASS, GenericType.STRING);
        CONNECTION_INIT_QUERY_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, GenericType.DURATION);
        CONNECTION_SET_KEYSPACE_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT, GenericType.DURATION);
        CONNECTION_MAX_REQUESTS = new TypedDriverOption<Integer>(DefaultDriverOption.CONNECTION_MAX_REQUESTS, GenericType.INTEGER);
        CONNECTION_MAX_ORPHAN_REQUESTS = new TypedDriverOption<Integer>(DefaultDriverOption.CONNECTION_MAX_ORPHAN_REQUESTS, GenericType.INTEGER);
        CONNECTION_WARN_INIT_ERROR = new TypedDriverOption<Boolean>(DefaultDriverOption.CONNECTION_WARN_INIT_ERROR, GenericType.BOOLEAN);
        CONNECTION_POOL_LOCAL_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, GenericType.INTEGER);
        CONNECTION_POOL_REMOTE_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, GenericType.INTEGER);
        RECONNECT_ON_INIT = new TypedDriverOption<Boolean>(DefaultDriverOption.RECONNECT_ON_INIT, GenericType.BOOLEAN);
        RECONNECTION_POLICY_CLASS = new TypedDriverOption<String>(DefaultDriverOption.RECONNECTION_POLICY_CLASS, GenericType.STRING);
        RECONNECTION_BASE_DELAY = new TypedDriverOption<Duration>(DefaultDriverOption.RECONNECTION_BASE_DELAY, GenericType.DURATION);
        RECONNECTION_MAX_DELAY = new TypedDriverOption<Duration>(DefaultDriverOption.RECONNECTION_MAX_DELAY, GenericType.DURATION);
        RETRY_POLICY_CLASS = new TypedDriverOption<String>(DefaultDriverOption.RETRY_POLICY_CLASS, GenericType.STRING);
        SPECULATIVE_EXECUTION_POLICY_CLASS = new TypedDriverOption<String>(DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS, GenericType.STRING);
        SPECULATIVE_EXECUTION_MAX = new TypedDriverOption<Integer>(DefaultDriverOption.SPECULATIVE_EXECUTION_MAX, GenericType.INTEGER);
        SPECULATIVE_EXECUTION_DELAY = new TypedDriverOption<Duration>(DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY, GenericType.DURATION);
        AUTH_PROVIDER_CLASS = new TypedDriverOption<String>(DefaultDriverOption.AUTH_PROVIDER_CLASS, GenericType.STRING);
        AUTH_PROVIDER_USER_NAME = new TypedDriverOption<String>(DefaultDriverOption.AUTH_PROVIDER_USER_NAME, GenericType.STRING);
        AUTH_PROVIDER_PASSWORD = new TypedDriverOption<String>(DefaultDriverOption.AUTH_PROVIDER_PASSWORD, GenericType.STRING);
        SSL_ENGINE_FACTORY_CLASS = new TypedDriverOption<String>(DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, GenericType.STRING);
        SSL_CIPHER_SUITES = new TypedDriverOption<List<String>>(DefaultDriverOption.SSL_CIPHER_SUITES, GenericType.listOf(String.class));
        SSL_HOSTNAME_VALIDATION = new TypedDriverOption<Boolean>(DefaultDriverOption.SSL_HOSTNAME_VALIDATION, GenericType.BOOLEAN);
        SSL_KEYSTORE_PATH = new TypedDriverOption<String>(DefaultDriverOption.SSL_KEYSTORE_PATH, GenericType.STRING);
        SSL_KEYSTORE_PASSWORD = new TypedDriverOption<String>(DefaultDriverOption.SSL_KEYSTORE_PASSWORD, GenericType.STRING);
        SSL_TRUSTSTORE_PATH = new TypedDriverOption<String>(DefaultDriverOption.SSL_TRUSTSTORE_PATH, GenericType.STRING);
        SSL_TRUSTSTORE_PASSWORD = new TypedDriverOption<String>(DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD, GenericType.STRING);
        TIMESTAMP_GENERATOR_CLASS = new TypedDriverOption<String>(DefaultDriverOption.TIMESTAMP_GENERATOR_CLASS, GenericType.STRING);
        TIMESTAMP_GENERATOR_FORCE_JAVA_CLOCK = new TypedDriverOption<Boolean>(DefaultDriverOption.TIMESTAMP_GENERATOR_FORCE_JAVA_CLOCK, GenericType.BOOLEAN);
        TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD = new TypedDriverOption<Duration>(DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD, GenericType.DURATION);
        TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL, GenericType.DURATION);
        REQUEST_TRACKER_CLASS = new TypedDriverOption<String>(DefaultDriverOption.REQUEST_TRACKER_CLASS, GenericType.STRING);
        REQUEST_LOGGER_SUCCESS_ENABLED = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_LOGGER_SUCCESS_ENABLED, GenericType.BOOLEAN);
        REQUEST_LOGGER_SLOW_THRESHOLD = new TypedDriverOption<Duration>(DefaultDriverOption.REQUEST_LOGGER_SLOW_THRESHOLD, GenericType.DURATION);
        REQUEST_LOGGER_SLOW_ENABLED = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_LOGGER_SLOW_ENABLED, GenericType.BOOLEAN);
        REQUEST_LOGGER_ERROR_ENABLED = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_LOGGER_ERROR_ENABLED, GenericType.BOOLEAN);
        REQUEST_LOGGER_MAX_QUERY_LENGTH = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, GenericType.INTEGER);
        REQUEST_LOGGER_VALUES = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_LOGGER_VALUES, GenericType.BOOLEAN);
        REQUEST_LOGGER_MAX_VALUE_LENGTH = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, GenericType.INTEGER);
        REQUEST_LOGGER_MAX_VALUES = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, GenericType.INTEGER);
        REQUEST_LOGGER_STACK_TRACES = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_LOGGER_STACK_TRACES, GenericType.BOOLEAN);
        REQUEST_THROTTLER_CLASS = new TypedDriverOption<String>(DefaultDriverOption.REQUEST_THROTTLER_CLASS, GenericType.STRING);
        REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_THROTTLER_MAX_CONCURRENT_REQUESTS, GenericType.INTEGER);
        REQUEST_THROTTLER_MAX_REQUESTS_PER_SECOND = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_THROTTLER_MAX_REQUESTS_PER_SECOND, GenericType.INTEGER);
        REQUEST_THROTTLER_MAX_QUEUE_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_THROTTLER_MAX_QUEUE_SIZE, GenericType.INTEGER);
        REQUEST_THROTTLER_DRAIN_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.REQUEST_THROTTLER_DRAIN_INTERVAL, GenericType.DURATION);
        METADATA_NODE_STATE_LISTENER_CLASS = new TypedDriverOption<String>(DefaultDriverOption.METADATA_NODE_STATE_LISTENER_CLASS, GenericType.STRING);
        METADATA_SCHEMA_CHANGE_LISTENER_CLASS = new TypedDriverOption<String>(DefaultDriverOption.METADATA_SCHEMA_CHANGE_LISTENER_CLASS, GenericType.STRING);
        ADDRESS_TRANSLATOR_CLASS = new TypedDriverOption<String>(DefaultDriverOption.ADDRESS_TRANSLATOR_CLASS, GenericType.STRING);
        PROTOCOL_VERSION = new TypedDriverOption<String>(DefaultDriverOption.PROTOCOL_VERSION, GenericType.STRING);
        PROTOCOL_COMPRESSION = new TypedDriverOption<String>(DefaultDriverOption.PROTOCOL_COMPRESSION, GenericType.STRING);
        PROTOCOL_MAX_FRAME_LENGTH = new TypedDriverOption<Long>(DefaultDriverOption.PROTOCOL_MAX_FRAME_LENGTH, GenericType.LONG);
        REQUEST_WARN_IF_SET_KEYSPACE = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_WARN_IF_SET_KEYSPACE, GenericType.BOOLEAN);
        REQUEST_TRACE_ATTEMPTS = new TypedDriverOption<Integer>(DefaultDriverOption.REQUEST_TRACE_ATTEMPTS, GenericType.INTEGER);
        REQUEST_TRACE_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.REQUEST_TRACE_INTERVAL, GenericType.DURATION);
        REQUEST_TRACE_CONSISTENCY = new TypedDriverOption<String>(DefaultDriverOption.REQUEST_TRACE_CONSISTENCY, GenericType.STRING);
        METRICS_SESSION_ENABLED = new TypedDriverOption<List<String>>(DefaultDriverOption.METRICS_SESSION_ENABLED, GenericType.listOf(String.class));
        METRICS_NODE_ENABLED = new TypedDriverOption<List<String>>(DefaultDriverOption.METRICS_NODE_ENABLED, GenericType.listOf(String.class));
        METRICS_SESSION_CQL_REQUESTS_HIGHEST = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_HIGHEST, GenericType.DURATION);
        METRICS_SESSION_CQL_REQUESTS_DIGITS = new TypedDriverOption<Integer>(DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS, GenericType.INTEGER);
        METRICS_SESSION_CQL_REQUESTS_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_SESSION_CQL_REQUESTS_INTERVAL, GenericType.DURATION);
        METRICS_SESSION_THROTTLING_HIGHEST = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_SESSION_THROTTLING_HIGHEST, GenericType.DURATION);
        METRICS_SESSION_THROTTLING_DIGITS = new TypedDriverOption<Integer>(DefaultDriverOption.METRICS_SESSION_THROTTLING_DIGITS, GenericType.INTEGER);
        METRICS_SESSION_THROTTLING_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_SESSION_THROTTLING_INTERVAL, GenericType.DURATION);
        METRICS_NODE_CQL_MESSAGES_HIGHEST = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST, GenericType.DURATION);
        METRICS_NODE_CQL_MESSAGES_DIGITS = new TypedDriverOption<Integer>(DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS, GenericType.INTEGER);
        METRICS_NODE_CQL_MESSAGES_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_NODE_CQL_MESSAGES_INTERVAL, GenericType.DURATION);
        SOCKET_TCP_NODELAY = new TypedDriverOption<Boolean>(DefaultDriverOption.SOCKET_TCP_NODELAY, GenericType.BOOLEAN);
        SOCKET_KEEP_ALIVE = new TypedDriverOption<Boolean>(DefaultDriverOption.SOCKET_KEEP_ALIVE, GenericType.BOOLEAN);
        SOCKET_REUSE_ADDRESS = new TypedDriverOption<Boolean>(DefaultDriverOption.SOCKET_REUSE_ADDRESS, GenericType.BOOLEAN);
        SOCKET_LINGER_INTERVAL = new TypedDriverOption<Integer>(DefaultDriverOption.SOCKET_LINGER_INTERVAL, GenericType.INTEGER);
        SOCKET_RECEIVE_BUFFER_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE, GenericType.INTEGER);
        SOCKET_SEND_BUFFER_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE, GenericType.INTEGER);
        HEARTBEAT_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.HEARTBEAT_INTERVAL, GenericType.DURATION);
        HEARTBEAT_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.HEARTBEAT_TIMEOUT, GenericType.DURATION);
        METADATA_TOPOLOGY_WINDOW = new TypedDriverOption<Duration>(DefaultDriverOption.METADATA_TOPOLOGY_WINDOW, GenericType.DURATION);
        METADATA_TOPOLOGY_MAX_EVENTS = new TypedDriverOption<Integer>(DefaultDriverOption.METADATA_TOPOLOGY_MAX_EVENTS, GenericType.INTEGER);
        METADATA_SCHEMA_ENABLED = new TypedDriverOption<Boolean>(DefaultDriverOption.METADATA_SCHEMA_ENABLED, GenericType.BOOLEAN);
        METADATA_SCHEMA_REQUEST_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT, GenericType.DURATION);
        METADATA_SCHEMA_REQUEST_PAGE_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.METADATA_SCHEMA_REQUEST_PAGE_SIZE, GenericType.INTEGER);
        METADATA_SCHEMA_REFRESHED_KEYSPACES = new TypedDriverOption<List<String>>(DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, GenericType.listOf(String.class));
        METADATA_SCHEMA_WINDOW = new TypedDriverOption<Duration>(DefaultDriverOption.METADATA_SCHEMA_WINDOW, GenericType.DURATION);
        METADATA_SCHEMA_MAX_EVENTS = new TypedDriverOption<Integer>(DefaultDriverOption.METADATA_SCHEMA_MAX_EVENTS, GenericType.INTEGER);
        METADATA_TOKEN_MAP_ENABLED = new TypedDriverOption<Boolean>(DefaultDriverOption.METADATA_TOKEN_MAP_ENABLED, GenericType.BOOLEAN);
        CONTROL_CONNECTION_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, GenericType.DURATION);
        CONTROL_CONNECTION_AGREEMENT_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_INTERVAL, GenericType.DURATION);
        CONTROL_CONNECTION_AGREEMENT_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT, GenericType.DURATION);
        CONTROL_CONNECTION_AGREEMENT_WARN = new TypedDriverOption<Boolean>(DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_WARN, GenericType.BOOLEAN);
        PREPARE_ON_ALL_NODES = new TypedDriverOption<Boolean>(DefaultDriverOption.PREPARE_ON_ALL_NODES, GenericType.BOOLEAN);
        REPREPARE_ENABLED = new TypedDriverOption<Boolean>(DefaultDriverOption.REPREPARE_ENABLED, GenericType.BOOLEAN);
        REPREPARE_CHECK_SYSTEM_TABLE = new TypedDriverOption<Boolean>(DefaultDriverOption.REPREPARE_CHECK_SYSTEM_TABLE, GenericType.BOOLEAN);
        REPREPARE_MAX_STATEMENTS = new TypedDriverOption<Integer>(DefaultDriverOption.REPREPARE_MAX_STATEMENTS, GenericType.INTEGER);
        REPREPARE_MAX_PARALLELISM = new TypedDriverOption<Integer>(DefaultDriverOption.REPREPARE_MAX_PARALLELISM, GenericType.INTEGER);
        REPREPARE_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.REPREPARE_TIMEOUT, GenericType.DURATION);
        NETTY_IO_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_IO_SIZE, GenericType.INTEGER);
        NETTY_IO_SHUTDOWN_QUIET_PERIOD = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD, GenericType.INTEGER);
        NETTY_IO_SHUTDOWN_TIMEOUT = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_IO_SHUTDOWN_TIMEOUT, GenericType.INTEGER);
        NETTY_IO_SHUTDOWN_UNIT = new TypedDriverOption<String>(DefaultDriverOption.NETTY_IO_SHUTDOWN_UNIT, GenericType.STRING);
        NETTY_ADMIN_SIZE = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_ADMIN_SIZE, GenericType.INTEGER);
        NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD, GenericType.INTEGER);
        NETTY_ADMIN_SHUTDOWN_TIMEOUT = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_TIMEOUT, GenericType.INTEGER);
        NETTY_ADMIN_SHUTDOWN_UNIT = new TypedDriverOption<String>(DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_UNIT, GenericType.STRING);
        COALESCER_MAX_RUNS = new TypedDriverOption<Integer>(DefaultDriverOption.COALESCER_MAX_RUNS, GenericType.INTEGER);
        COALESCER_INTERVAL = new TypedDriverOption<Duration>(DefaultDriverOption.COALESCER_INTERVAL, GenericType.DURATION);
        RESOLVE_CONTACT_POINTS = new TypedDriverOption<Boolean>(DefaultDriverOption.RESOLVE_CONTACT_POINTS, GenericType.BOOLEAN);
        NETTY_TIMER_TICK_DURATION = new TypedDriverOption<Duration>(DefaultDriverOption.NETTY_TIMER_TICK_DURATION, GenericType.DURATION);
        NETTY_TIMER_TICKS_PER_WHEEL = new TypedDriverOption<Integer>(DefaultDriverOption.NETTY_TIMER_TICKS_PER_WHEEL, GenericType.INTEGER);
        REQUEST_LOG_WARNINGS = new TypedDriverOption<Boolean>(DefaultDriverOption.REQUEST_LOG_WARNINGS, GenericType.BOOLEAN);
        NETTY_DAEMON = new TypedDriverOption<Boolean>(DefaultDriverOption.NETTY_DAEMON, GenericType.BOOLEAN);
        CLOUD_SECURE_CONNECT_BUNDLE = new TypedDriverOption<String>(DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, GenericType.STRING);
        LOAD_BALANCING_POLICY_SLOW_AVOIDANCE = new TypedDriverOption<Boolean>(DefaultDriverOption.LOAD_BALANCING_POLICY_SLOW_AVOIDANCE, GenericType.BOOLEAN);
        CONNECTION_CONNECT_TIMEOUT = new TypedDriverOption<Duration>(DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, GenericType.DURATION);
        SESSION_LEAK_THRESHOLD = new TypedDriverOption<Integer>(DefaultDriverOption.SESSION_LEAK_THRESHOLD, GenericType.INTEGER);
        APPLICATION_NAME = new TypedDriverOption<String>(DseDriverOption.APPLICATION_NAME, GenericType.STRING);
        APPLICATION_VERSION = new TypedDriverOption<String>(DseDriverOption.APPLICATION_VERSION, GenericType.STRING);
        AUTH_PROVIDER_AUTHORIZATION_ID = new TypedDriverOption<String>(DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID, GenericType.STRING);
        AUTH_PROVIDER_SERVICE = new TypedDriverOption<String>(DseDriverOption.AUTH_PROVIDER_SERVICE, GenericType.STRING);
        AUTH_PROVIDER_LOGIN_CONFIGURATION = new TypedDriverOption<String>(DseDriverOption.AUTH_PROVIDER_LOGIN_CONFIGURATION, GenericType.STRING);
        AUTH_PROVIDER_SASL_PROPERTIES = new TypedDriverOption<Map<String, String>>(DseDriverOption.AUTH_PROVIDER_SASL_PROPERTIES, GenericType.mapOf(GenericType.STRING, GenericType.STRING));
        CONTINUOUS_PAGING_PAGE_SIZE = new TypedDriverOption<Integer>(DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE, GenericType.INTEGER);
        CONTINUOUS_PAGING_PAGE_SIZE_BYTES = new TypedDriverOption<Boolean>(DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE_BYTES, GenericType.BOOLEAN);
        CONTINUOUS_PAGING_MAX_PAGES = new TypedDriverOption<Integer>(DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES, GenericType.INTEGER);
        CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND = new TypedDriverOption<Integer>(DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, GenericType.INTEGER);
        CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES = new TypedDriverOption<Integer>(DseDriverOption.CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES, GenericType.INTEGER);
        CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE = new TypedDriverOption<Duration>(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE, GenericType.DURATION);
        CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES = new TypedDriverOption<Duration>(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES, GenericType.DURATION);
        CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST = new TypedDriverOption<Duration>(DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST, GenericType.DURATION);
        CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS = new TypedDriverOption<Integer>(DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS, GenericType.INTEGER);
        CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_INTERVAL = new TypedDriverOption<Duration>(DseDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_INTERVAL, GenericType.DURATION);
        GRAPH_READ_CONSISTENCY_LEVEL = new TypedDriverOption<String>(DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, GenericType.STRING);
        GRAPH_WRITE_CONSISTENCY_LEVEL = new TypedDriverOption<String>(DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, GenericType.STRING);
        GRAPH_TRAVERSAL_SOURCE = new TypedDriverOption<String>(DseDriverOption.GRAPH_TRAVERSAL_SOURCE, GenericType.STRING);
        GRAPH_SUB_PROTOCOL = new TypedDriverOption<String>(DseDriverOption.GRAPH_SUB_PROTOCOL, GenericType.STRING);
        GRAPH_IS_SYSTEM_QUERY = new TypedDriverOption<Boolean>(DseDriverOption.GRAPH_IS_SYSTEM_QUERY, GenericType.BOOLEAN);
        GRAPH_NAME = new TypedDriverOption<String>(DseDriverOption.GRAPH_NAME, GenericType.STRING);
        GRAPH_TIMEOUT = new TypedDriverOption<Duration>(DseDriverOption.GRAPH_TIMEOUT, GenericType.DURATION);
        MONITOR_REPORTING_ENABLED = new TypedDriverOption<Boolean>(DseDriverOption.MONITOR_REPORTING_ENABLED, GenericType.BOOLEAN);
        GRAPH_PAGING_ENABLED = new TypedDriverOption<String>(DseDriverOption.GRAPH_PAGING_ENABLED, GenericType.STRING);
        GRAPH_CONTINUOUS_PAGING_PAGE_SIZE = new TypedDriverOption<Integer>(DseDriverOption.GRAPH_CONTINUOUS_PAGING_PAGE_SIZE, GenericType.INTEGER);
        GRAPH_CONTINUOUS_PAGING_MAX_PAGES = new TypedDriverOption<Integer>(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES, GenericType.INTEGER);
        GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND = new TypedDriverOption<Integer>(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, GenericType.INTEGER);
        GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES = new TypedDriverOption<Integer>(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES, GenericType.INTEGER);
        METRICS_SESSION_GRAPH_REQUESTS_HIGHEST = new TypedDriverOption<Duration>(DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_HIGHEST, GenericType.DURATION);
        METRICS_SESSION_GRAPH_REQUESTS_DIGITS = new TypedDriverOption<Integer>(DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_DIGITS, GenericType.INTEGER);
        METRICS_SESSION_GRAPH_REQUESTS_INTERVAL = new TypedDriverOption<Duration>(DseDriverOption.METRICS_SESSION_GRAPH_REQUESTS_INTERVAL, GenericType.DURATION);
        METRICS_NODE_GRAPH_MESSAGES_HIGHEST = new TypedDriverOption<Duration>(DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_HIGHEST, GenericType.DURATION);
        METRICS_NODE_GRAPH_MESSAGES_DIGITS = new TypedDriverOption<Integer>(DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_DIGITS, GenericType.INTEGER);
        METRICS_NODE_GRAPH_MESSAGES_INTERVAL = new TypedDriverOption<Duration>(DseDriverOption.METRICS_NODE_GRAPH_MESSAGES_INTERVAL, GenericType.DURATION);
        METRICS_NODE_EXPIRE_AFTER = new TypedDriverOption<Duration>(DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER, GenericType.DURATION);
    }
}

