/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class OptionsMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<String, Map<DriverOption, Object>> map;
    private final List<Consumer<OptionsMap>> changeListeners = new CopyOnWriteArrayList<Consumer<OptionsMap>>();

    @NonNull
    public static OptionsMap driverDefaults() {
        OptionsMap source = new OptionsMap();
        OptionsMap.fillWithDriverDefaults(source);
        return source;
    }

    public OptionsMap() {
        this(new ConcurrentHashMap<String, Map<DriverOption, Object>>());
    }

    private OptionsMap(ConcurrentHashMap<String, Map<DriverOption, Object>> map2) {
        this.map = map2;
    }

    @Nullable
    public <ValueT> ValueT put(@NonNull String profile, @NonNull TypedDriverOption<ValueT> option2, @NonNull ValueT value2) {
        Objects.requireNonNull(option2, "option");
        Objects.requireNonNull(value2, "value");
        Object previous = this.getProfileMap(profile).put(option2.getRawOption(), value2);
        if (!value2.equals(previous)) {
            for (Consumer<OptionsMap> listener : this.changeListeners) {
                listener.accept(this);
            }
        }
        return this.cast(previous);
    }

    @Nullable
    public <ValueT> ValueT put(@NonNull TypedDriverOption<ValueT> option2, @NonNull ValueT value2) {
        return this.put("default", option2, value2);
    }

    @Nullable
    public <ValueT> ValueT get(@NonNull String profile, @NonNull TypedDriverOption<ValueT> option2) {
        Objects.requireNonNull(option2, "option");
        Object result2 = this.getProfileMap(profile).get(option2.getRawOption());
        return this.cast(result2);
    }

    @Nullable
    public <ValueT> ValueT get(@NonNull TypedDriverOption<ValueT> option2) {
        return this.get("default", option2);
    }

    @Nullable
    public <ValueT> ValueT remove(@NonNull String profile, @NonNull TypedDriverOption<ValueT> option2) {
        Objects.requireNonNull(option2, "option");
        Object previous = this.getProfileMap(profile).remove(option2.getRawOption());
        if (previous != null) {
            for (Consumer<OptionsMap> listener : this.changeListeners) {
                listener.accept(this);
            }
        }
        return this.cast(previous);
    }

    @Nullable
    public <ValueT> ValueT remove(@NonNull TypedDriverOption<ValueT> option2) {
        return this.remove("default", option2);
    }

    public void addChangeListener(@NonNull Consumer<OptionsMap> listener) {
        this.changeListeners.add(Objects.requireNonNull(listener));
    }

    public boolean removeChangeListener(@NonNull Consumer<OptionsMap> listener) {
        return this.changeListeners.remove(Objects.requireNonNull(listener));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OptionsMap) {
            OptionsMap that = (OptionsMap)other;
            return this.map.equals(that.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @NonNull
    protected Map<String, Map<DriverOption, Object>> asRawMap() {
        return this.map;
    }

    @NonNull
    private Map<DriverOption, Object> getProfileMap(@NonNull String profile) {
        Objects.requireNonNull(profile, "profile");
        return this.map.computeIfAbsent(profile, p -> new ConcurrentHashMap());
    }

    @Nullable
    private <ValueT> ValueT cast(@Nullable Object value2) {
        return (ValueT)value2;
    }

    private Object writeReplace() {
        return new SerializationProxy(this.map);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    protected static void fillWithDriverDefaults(OptionsMap map2) {
        Duration initQueryTimeout = Duration.ofSeconds(5L);
        Duration requestTimeout = Duration.ofSeconds(2L);
        int requestPageSize = 5000;
        int continuousMaxPages = 0;
        int continuousMaxPagesPerSecond = 0;
        int continuousMaxEnqueuedPages = 4;
        map2.put(TypedDriverOption.REQUEST_TIMEOUT, requestTimeout);
        map2.put(TypedDriverOption.REQUEST_CONSISTENCY, "LOCAL_ONE");
        map2.put(TypedDriverOption.REQUEST_PAGE_SIZE, requestPageSize);
        map2.put(TypedDriverOption.REQUEST_SERIAL_CONSISTENCY, "SERIAL");
        map2.put(TypedDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, false);
        map2.put(TypedDriverOption.GRAPH_TRAVERSAL_SOURCE, "g");
        map2.put(TypedDriverOption.LOAD_BALANCING_POLICY_CLASS, "DefaultLoadBalancingPolicy");
        map2.put(TypedDriverOption.LOAD_BALANCING_POLICY_SLOW_AVOIDANCE, true);
        map2.put(TypedDriverOption.SESSION_LEAK_THRESHOLD, 4);
        map2.put(TypedDriverOption.CONNECTION_CONNECT_TIMEOUT, Duration.ofSeconds(5L));
        map2.put(TypedDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, initQueryTimeout);
        map2.put(TypedDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT, initQueryTimeout);
        map2.put(TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, 1);
        map2.put(TypedDriverOption.CONNECTION_POOL_REMOTE_SIZE, 1);
        map2.put(TypedDriverOption.CONNECTION_MAX_REQUESTS, 1024);
        map2.put(TypedDriverOption.CONNECTION_MAX_ORPHAN_REQUESTS, 256);
        map2.put(TypedDriverOption.CONNECTION_WARN_INIT_ERROR, true);
        map2.put(TypedDriverOption.RECONNECT_ON_INIT, false);
        map2.put(TypedDriverOption.RECONNECTION_POLICY_CLASS, "ExponentialReconnectionPolicy");
        map2.put(TypedDriverOption.RECONNECTION_BASE_DELAY, Duration.ofSeconds(1L));
        map2.put(TypedDriverOption.RECONNECTION_MAX_DELAY, Duration.ofSeconds(60L));
        map2.put(TypedDriverOption.RETRY_POLICY_CLASS, "DefaultRetryPolicy");
        map2.put(TypedDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS, "NoSpeculativeExecutionPolicy");
        map2.put(TypedDriverOption.TIMESTAMP_GENERATOR_CLASS, "AtomicTimestampGenerator");
        map2.put(TypedDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD, Duration.ofSeconds(1L));
        map2.put(TypedDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL, Duration.ofSeconds(10L));
        map2.put(TypedDriverOption.TIMESTAMP_GENERATOR_FORCE_JAVA_CLOCK, false);
        map2.put(TypedDriverOption.REQUEST_TRACKER_CLASS, "NoopRequestTracker");
        map2.put(TypedDriverOption.REQUEST_THROTTLER_CLASS, "PassThroughRequestThrottler");
        map2.put(TypedDriverOption.METADATA_NODE_STATE_LISTENER_CLASS, "NoopNodeStateListener");
        map2.put(TypedDriverOption.METADATA_SCHEMA_CHANGE_LISTENER_CLASS, "NoopSchemaChangeListener");
        map2.put(TypedDriverOption.ADDRESS_TRANSLATOR_CLASS, "PassThroughAddressTranslator");
        map2.put(TypedDriverOption.RESOLVE_CONTACT_POINTS, true);
        map2.put(TypedDriverOption.PROTOCOL_MAX_FRAME_LENGTH, 0x10000000L);
        map2.put(TypedDriverOption.REQUEST_WARN_IF_SET_KEYSPACE, true);
        map2.put(TypedDriverOption.REQUEST_TRACE_ATTEMPTS, 5);
        map2.put(TypedDriverOption.REQUEST_TRACE_INTERVAL, Duration.ofMillis(3L));
        map2.put(TypedDriverOption.REQUEST_TRACE_CONSISTENCY, "ONE");
        map2.put(TypedDriverOption.REQUEST_LOG_WARNINGS, true);
        map2.put(TypedDriverOption.GRAPH_PAGING_ENABLED, "AUTO");
        map2.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_PAGE_SIZE, requestPageSize);
        map2.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES, continuousMaxPages);
        map2.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, continuousMaxPagesPerSecond);
        map2.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES, continuousMaxEnqueuedPages);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_PAGE_SIZE, requestPageSize);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_PAGE_SIZE_BYTES, false);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_PAGES, continuousMaxPages);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, continuousMaxPagesPerSecond);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES, continuousMaxEnqueuedPages);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE, Duration.ofSeconds(2L));
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES, Duration.ofSeconds(1L));
        map2.put(TypedDriverOption.MONITOR_REPORTING_ENABLED, true);
        map2.put(TypedDriverOption.METRICS_SESSION_ENABLED, Collections.emptyList());
        map2.put(TypedDriverOption.METRICS_SESSION_CQL_REQUESTS_HIGHEST, Duration.ofSeconds(3L));
        map2.put(TypedDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS, 3);
        map2.put(TypedDriverOption.METRICS_SESSION_CQL_REQUESTS_INTERVAL, Duration.ofMinutes(5L));
        map2.put(TypedDriverOption.METRICS_SESSION_THROTTLING_HIGHEST, Duration.ofSeconds(3L));
        map2.put(TypedDriverOption.METRICS_SESSION_THROTTLING_DIGITS, 3);
        map2.put(TypedDriverOption.METRICS_SESSION_THROTTLING_INTERVAL, Duration.ofMinutes(5L));
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST, Duration.ofMinutes(2L));
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS, 3);
        map2.put(TypedDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_INTERVAL, Duration.ofMinutes(5L));
        map2.put(TypedDriverOption.METRICS_SESSION_GRAPH_REQUESTS_HIGHEST, Duration.ofSeconds(12L));
        map2.put(TypedDriverOption.METRICS_SESSION_GRAPH_REQUESTS_DIGITS, 3);
        map2.put(TypedDriverOption.METRICS_SESSION_GRAPH_REQUESTS_INTERVAL, Duration.ofMinutes(5L));
        map2.put(TypedDriverOption.METRICS_NODE_ENABLED, Collections.emptyList());
        map2.put(TypedDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST, Duration.ofSeconds(3L));
        map2.put(TypedDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS, 3);
        map2.put(TypedDriverOption.METRICS_NODE_CQL_MESSAGES_INTERVAL, Duration.ofMinutes(5L));
        map2.put(TypedDriverOption.METRICS_NODE_GRAPH_MESSAGES_HIGHEST, Duration.ofSeconds(3L));
        map2.put(TypedDriverOption.METRICS_NODE_GRAPH_MESSAGES_DIGITS, 3);
        map2.put(TypedDriverOption.METRICS_NODE_GRAPH_MESSAGES_INTERVAL, Duration.ofMinutes(5L));
        map2.put(TypedDriverOption.METRICS_NODE_EXPIRE_AFTER, Duration.ofHours(1L));
        map2.put(TypedDriverOption.SOCKET_TCP_NODELAY, true);
        map2.put(TypedDriverOption.HEARTBEAT_INTERVAL, Duration.ofSeconds(30L));
        map2.put(TypedDriverOption.HEARTBEAT_TIMEOUT, initQueryTimeout);
        map2.put(TypedDriverOption.METADATA_TOPOLOGY_WINDOW, Duration.ofSeconds(1L));
        map2.put(TypedDriverOption.METADATA_TOPOLOGY_MAX_EVENTS, 20);
        map2.put(TypedDriverOption.METADATA_SCHEMA_ENABLED, true);
        map2.put(TypedDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT, requestTimeout);
        map2.put(TypedDriverOption.METADATA_SCHEMA_REQUEST_PAGE_SIZE, requestPageSize);
        map2.put(TypedDriverOption.METADATA_SCHEMA_WINDOW, Duration.ofSeconds(1L));
        map2.put(TypedDriverOption.METADATA_SCHEMA_MAX_EVENTS, 20);
        map2.put(TypedDriverOption.METADATA_TOKEN_MAP_ENABLED, true);
        map2.put(TypedDriverOption.CONTROL_CONNECTION_TIMEOUT, initQueryTimeout);
        map2.put(TypedDriverOption.CONTROL_CONNECTION_AGREEMENT_INTERVAL, Duration.ofMillis(200L));
        map2.put(TypedDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT, Duration.ofSeconds(10L));
        map2.put(TypedDriverOption.CONTROL_CONNECTION_AGREEMENT_WARN, true);
        map2.put(TypedDriverOption.PREPARE_ON_ALL_NODES, true);
        map2.put(TypedDriverOption.REPREPARE_ENABLED, true);
        map2.put(TypedDriverOption.REPREPARE_CHECK_SYSTEM_TABLE, false);
        map2.put(TypedDriverOption.REPREPARE_MAX_STATEMENTS, 0);
        map2.put(TypedDriverOption.REPREPARE_MAX_PARALLELISM, 100);
        map2.put(TypedDriverOption.REPREPARE_TIMEOUT, initQueryTimeout);
        map2.put(TypedDriverOption.NETTY_DAEMON, false);
        map2.put(TypedDriverOption.NETTY_IO_SIZE, 0);
        map2.put(TypedDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD, 2);
        map2.put(TypedDriverOption.NETTY_IO_SHUTDOWN_TIMEOUT, 15);
        map2.put(TypedDriverOption.NETTY_IO_SHUTDOWN_UNIT, "SECONDS");
        map2.put(TypedDriverOption.NETTY_ADMIN_SIZE, 2);
        map2.put(TypedDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD, 2);
        map2.put(TypedDriverOption.NETTY_ADMIN_SHUTDOWN_TIMEOUT, 15);
        map2.put(TypedDriverOption.NETTY_ADMIN_SHUTDOWN_UNIT, "SECONDS");
        map2.put(TypedDriverOption.NETTY_TIMER_TICK_DURATION, Duration.ofMillis(100L));
        map2.put(TypedDriverOption.NETTY_TIMER_TICKS_PER_WHEEL, 2048);
        map2.put(TypedDriverOption.COALESCER_INTERVAL, Duration.of(10L, ChronoUnit.MICROS));
    }

    @Immutable
    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ConcurrentHashMap<String, Map<DriverOption, Object>> map;

        private SerializationProxy(ConcurrentHashMap<String, Map<DriverOption, Object>> map2) {
            this.map = map2;
        }

        private Object readResolve() {
            return new OptionsMap(this.map);
        }
    }
}

