/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OngoingConfigOptions;
import com.datastax.oss.driver.internal.core.config.DerivedExecutionProfile;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public interface DriverExecutionProfile
extends OngoingConfigOptions<DriverExecutionProfile> {
    public static final String DEFAULT_NAME = "default";

    @NonNull
    public String getName();

    public boolean isDefined(@NonNull DriverOption var1);

    public boolean getBoolean(@NonNull DriverOption var1);

    default public boolean getBoolean(@NonNull DriverOption option2, boolean defaultValue2) {
        return this.isDefined(option2) ? this.getBoolean(option2) : defaultValue2;
    }

    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption var1);

    @Nullable
    default public List<Boolean> getBooleanList(@NonNull DriverOption option2, @Nullable List<Boolean> defaultValue2) {
        return this.isDefined(option2) ? this.getBooleanList(option2) : defaultValue2;
    }

    public int getInt(@NonNull DriverOption var1);

    default public int getInt(@NonNull DriverOption option2, int defaultValue2) {
        return this.isDefined(option2) ? this.getInt(option2) : defaultValue2;
    }

    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption var1);

    @Nullable
    default public List<Integer> getIntList(@NonNull DriverOption option2, @Nullable List<Integer> defaultValue2) {
        return this.isDefined(option2) ? this.getIntList(option2) : defaultValue2;
    }

    public long getLong(@NonNull DriverOption var1);

    default public long getLong(@NonNull DriverOption option2, long defaultValue2) {
        return this.isDefined(option2) ? this.getLong(option2) : defaultValue2;
    }

    @NonNull
    public List<Long> getLongList(@NonNull DriverOption var1);

    @Nullable
    default public List<Long> getLongList(@NonNull DriverOption option2, @Nullable List<Long> defaultValue2) {
        return this.isDefined(option2) ? this.getLongList(option2) : defaultValue2;
    }

    public double getDouble(@NonNull DriverOption var1);

    default public double getDouble(@NonNull DriverOption option2, double defaultValue2) {
        return this.isDefined(option2) ? this.getDouble(option2) : defaultValue2;
    }

    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption var1);

    @Nullable
    default public List<Double> getDoubleList(@NonNull DriverOption option2, @Nullable List<Double> defaultValue2) {
        return this.isDefined(option2) ? this.getDoubleList(option2) : defaultValue2;
    }

    @NonNull
    public String getString(@NonNull DriverOption var1);

    @Nullable
    default public String getString(@NonNull DriverOption option2, @Nullable String defaultValue2) {
        return this.isDefined(option2) ? this.getString(option2) : defaultValue2;
    }

    @NonNull
    public List<String> getStringList(@NonNull DriverOption var1);

    @Nullable
    default public List<String> getStringList(@NonNull DriverOption option2, @Nullable List<String> defaultValue2) {
        return this.isDefined(option2) ? this.getStringList(option2) : defaultValue2;
    }

    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption var1);

    @Nullable
    default public Map<String, String> getStringMap(@NonNull DriverOption option2, @Nullable Map<String, String> defaultValue2) {
        return this.isDefined(option2) ? this.getStringMap(option2) : defaultValue2;
    }

    public long getBytes(@NonNull DriverOption var1);

    default public long getBytes(@NonNull DriverOption option2, long defaultValue2) {
        return this.isDefined(option2) ? this.getBytes(option2) : defaultValue2;
    }

    @NonNull
    public List<Long> getBytesList(DriverOption var1);

    @Nullable
    default public List<Long> getBytesList(DriverOption option2, @Nullable List<Long> defaultValue2) {
        return this.isDefined(option2) ? this.getBytesList(option2) : defaultValue2;
    }

    @NonNull
    public Duration getDuration(@NonNull DriverOption var1);

    @Nullable
    default public Duration getDuration(@NonNull DriverOption option2, @Nullable Duration defaultValue2) {
        return this.isDefined(option2) ? this.getDuration(option2) : defaultValue2;
    }

    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption var1);

    @Nullable
    default public List<Duration> getDurationList(@NonNull DriverOption option2, @Nullable List<Duration> defaultValue2) {
        return this.isDefined(option2) ? this.getDurationList(option2) : defaultValue2;
    }

    @NonNull
    default public Object getComparisonKey(@NonNull DriverOption option2) {
        String prefix = option2.getPath();
        ImmutableMap.Builder childOptions = ImmutableMap.builder();
        for (Map.Entry entry2 : this.entrySet()) {
            if (!((String)entry2.getKey()).startsWith(prefix)) continue;
            childOptions.put((String)entry2.getKey(), entry2.getValue());
        }
        return childOptions.build();
    }

    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet();

    @Override
    @NonNull
    default public DriverExecutionProfile withBoolean(@NonNull DriverOption option2, boolean value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withBooleanList(@NonNull DriverOption option2, @NonNull List<Boolean> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withInt(@NonNull DriverOption option2, int value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withIntList(@NonNull DriverOption option2, @NonNull List<Integer> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withLong(@NonNull DriverOption option2, long value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withLongList(@NonNull DriverOption option2, @NonNull List<Long> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDouble(@NonNull DriverOption option2, double value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDoubleList(@NonNull DriverOption option2, @NonNull List<Double> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withString(@NonNull DriverOption option2, @NonNull String value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withStringList(@NonNull DriverOption option2, @NonNull List<String> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withStringMap(@NonNull DriverOption option2, @NonNull Map<String, String> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withBytes(@NonNull DriverOption option2, long value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withBytesList(@NonNull DriverOption option2, @NonNull List<Long> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDuration(@NonNull DriverOption option2, @NonNull Duration value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDurationList(@NonNull DriverOption option2, @NonNull List<Duration> value2) {
        return DerivedExecutionProfile.with(this, option2, value2);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile without(@NonNull DriverOption option2) {
        return DerivedExecutionProfile.without(this, option2);
    }
}

