/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.AsyncPagingIterableWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface AsyncPagingIterable<ElementT, SelfT extends AsyncPagingIterable<ElementT, SelfT>> {
    @NonNull
    public ColumnDefinitions getColumnDefinitions();

    @NonNull
    public ExecutionInfo getExecutionInfo();

    public int remaining();

    @NonNull
    public Iterable<ElementT> currentPage();

    @Nullable
    default public ElementT one() {
        Iterator<ElementT> iterator2 = this.currentPage().iterator();
        return iterator2.hasNext() ? (ElementT)iterator2.next() : null;
    }

    public boolean hasMorePages();

    @NonNull
    public CompletionStage<SelfT> fetchNextPage() throws IllegalStateException;

    public boolean wasApplied();

    default public <TargetT> MappedAsyncPagingIterable<TargetT> map(Function<? super ElementT, ? extends TargetT> elementMapper) {
        return new AsyncPagingIterableWrapper<ElementT, TargetT>(this, elementMapper);
    }
}

