/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DseRowsMetadata
extends RowsMetadata {
    public final int continuousPageNumber;
    public final boolean isLastContinuousPage;

    public DseRowsMetadata(List<ColumnSpec> columnSpecs, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId, int continuousPageNumber, boolean isLastContinuousPage) {
        this(DseRowsMetadata.computeFlags(false, columnSpecs, pagingState, newResultMetadataId, continuousPageNumber, isLastContinuousPage), columnSpecs, columnSpecs.size(), pagingState, pkIndices, newResultMetadataId, continuousPageNumber, isLastContinuousPage);
    }

    public DseRowsMetadata(int columnCount, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId, int continuousPageNumber, boolean isLastContinuousPage) {
        this(DseRowsMetadata.computeFlags(true, Collections.emptyList(), pagingState, newResultMetadataId, continuousPageNumber, isLastContinuousPage), Collections.emptyList(), columnCount, pagingState, pkIndices, newResultMetadataId, continuousPageNumber, isLastContinuousPage);
    }

    protected DseRowsMetadata(int flags2, List<ColumnSpec> columnSpecs, int columnCount, ByteBuffer pagingState, int[] pkIndices, byte[] newResultMetadataId, int continuousPageNumber, boolean isLastContinuousPage) {
        super(flags2, columnSpecs, columnCount, pagingState, pkIndices, newResultMetadataId);
        this.continuousPageNumber = continuousPageNumber;
        this.isLastContinuousPage = isLastContinuousPage;
    }

    protected static int computeFlags(boolean noMetadata, List<ColumnSpec> columnSpecs, ByteBuffer pagingState, byte[] newResultMetadataId, int continuousPageNumber, boolean isLastContinuousPage) {
        int flags2 = RowsMetadata.computeFlags(noMetadata, columnSpecs, pagingState, newResultMetadataId);
        if (continuousPageNumber >= 0) {
            flags2 = Flags.add(flags2, 0x40000000);
        }
        if (isLastContinuousPage) {
            flags2 = Flags.add(flags2, Integer.MIN_VALUE);
        }
        return flags2;
    }

    @Override
    public <B> void encode(B dest, PrimitiveCodec<B> encoder2, boolean withPkIndices, int protocolVersion) {
        encoder2.writeInt(this.flags, dest);
        encoder2.writeInt(this.columnCount, dest);
        if (withPkIndices) {
            if (this.pkIndices == null) {
                encoder2.writeInt(0, dest);
            } else {
                encoder2.writeInt(this.pkIndices.length, dest);
                for (int pkIndex : this.pkIndices) {
                    encoder2.writeUnsignedShort(pkIndex, dest);
                }
            }
        }
        if (Flags.contains(this.flags, 2)) {
            encoder2.writeBytes(this.pagingState, dest);
        }
        if (Flags.contains(this.flags, 8)) {
            encoder2.writeShortBytes(this.newResultMetadataId, dest);
        }
        if (Flags.contains(this.flags, 0x40000000)) {
            encoder2.writeInt(this.continuousPageNumber, dest);
        }
        if (!Flags.contains(this.flags, 4) && !this.columnSpecs.isEmpty()) {
            boolean globalTable = Flags.contains(this.flags, 1);
            if (globalTable) {
                ColumnSpec firstSpec = (ColumnSpec)this.columnSpecs.get(0);
                encoder2.writeString(firstSpec.ksName, dest);
                encoder2.writeString(firstSpec.tableName, dest);
            }
            for (ColumnSpec spec : this.columnSpecs) {
                if (!globalTable) {
                    encoder2.writeString(spec.ksName, dest);
                    encoder2.writeString(spec.tableName, dest);
                }
                encoder2.writeString(spec.name, dest);
                spec.type.encode(dest, encoder2, protocolVersion);
            }
        }
    }

    @Override
    public int encodedSize(boolean withPkIndices, int protocolVersion) {
        return super.encodedSize(withPkIndices, protocolVersion) + (Flags.contains(this.flags, 0x40000000) ? 4 : 0);
    }

    public static <B> DseRowsMetadata decode(B source, PrimitiveCodec<B> decoder2, boolean withPkIndices, int protocolVersion) {
        List<ColumnSpec> columnSpecs;
        int pkCount;
        int flags2 = decoder2.readInt(source);
        int columnCount = decoder2.readInt(source);
        int[] pkIndices = null;
        if (withPkIndices && (pkCount = decoder2.readInt(source)) > 0) {
            pkIndices = new int[pkCount];
            for (int i = 0; i < pkCount; ++i) {
                pkIndices[i] = decoder2.readUnsignedShort(source);
            }
        }
        ByteBuffer state = Flags.contains(flags2, 2) ? decoder2.readBytes(source) : null;
        byte[] newResultMetadataId = Flags.contains(flags2, 8) ? decoder2.readShortBytes(source) : null;
        int continuousPageNumber = Flags.contains(flags2, 0x40000000) ? decoder2.readInt(source) : -1;
        boolean isLastContinuousPage = Flags.contains(flags2, Integer.MIN_VALUE);
        if (Flags.contains(flags2, 4)) {
            columnSpecs = Collections.emptyList();
        } else {
            boolean globalTablesSpec = Flags.contains(flags2, 1);
            String globalKsName = null;
            String globalCfName = null;
            if (globalTablesSpec) {
                globalKsName = decoder2.readString(source);
                globalCfName = decoder2.readString(source);
            }
            ArrayList<ColumnSpec> tmpSpecs = new ArrayList<ColumnSpec>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String ksName = globalTablesSpec ? globalKsName : decoder2.readString(source);
                String cfName = globalTablesSpec ? globalCfName : decoder2.readString(source);
                String name2 = decoder2.readString(source);
                RawType type = RawType.decode(source, decoder2, protocolVersion);
                tmpSpecs.add(new ColumnSpec(ksName, cfName, name2, i, type));
            }
            columnSpecs = Collections.unmodifiableList(tmpSpecs);
        }
        return new DseRowsMetadata(flags2, columnSpecs, columnCount, state, pkIndices, newResultMetadataId, continuousPageNumber, isLastContinuousPage);
    }
}

