/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;

public class DsePreparedSubCodec
extends Result.SubCodec {
    public DsePreparedSubCodec(int protocolVersion) {
        super(4, protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
        Prepared prepared = (Prepared)message;
        encoder2.writeShortBytes(prepared.preparedQueryId, dest);
        if (this.protocolVersion >= 66) {
            encoder2.writeShortBytes(prepared.resultMetadataId, dest);
        }
        prepared.variablesMetadata.encode(dest, encoder2, true, this.protocolVersion);
        prepared.resultMetadata.encode(dest, encoder2, false, this.protocolVersion);
    }

    @Override
    public int encodedSize(Message message) {
        Prepared prepared = (Prepared)message;
        int size2 = PrimitiveSizes.sizeOfShortBytes(prepared.preparedQueryId);
        if (this.protocolVersion >= 66) {
            assert (prepared.resultMetadataId != null);
            size2 += PrimitiveSizes.sizeOfShortBytes(prepared.resultMetadataId);
        }
        size2 += prepared.variablesMetadata.encodedSize(true, this.protocolVersion);
        return size2 += prepared.resultMetadata.encodedSize(false, this.protocolVersion);
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
        byte[] preparedQueryId = decoder2.readShortBytes(source);
        byte[] resultMetadataId = this.protocolVersion >= 66 ? decoder2.readShortBytes(source) : null;
        RowsMetadata variablesMetadata = RowsMetadata.decode(source, decoder2, true, this.protocolVersion);
        RowsMetadata resultMetadata = RowsMetadata.decode(source, decoder2, false, this.protocolVersion);
        return new Prepared(preparedQueryId, resultMetadataId, variablesMetadata, resultMetadata);
    }
}

