/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request.query;

import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DseQueryOptionsCodec
extends QueryOptions.Codec {
    public DseQueryOptionsCodec(int protocolVersion) {
        super(protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, QueryOptions options, PrimitiveCodec<B> encoder2) {
        ContinuousPagingOptions continuousPagingOptions;
        encoder2.writeUnsignedShort(options.consistency, dest);
        encoder2.writeInt(options.flags, dest);
        if (Flags.contains(options.flags, 1)) {
            if (Flags.contains(options.flags, 64)) {
                Values.writeNamedValues(options.namedValues, dest, encoder2);
            } else {
                Values.writePositionalValues(options.positionalValues, dest, encoder2);
            }
        }
        if (Flags.contains(options.flags, 4)) {
            encoder2.writeInt(options.pageSize, dest);
        }
        if (Flags.contains(options.flags, 8)) {
            encoder2.writeBytes(options.pagingState, dest);
        }
        if (Flags.contains(options.flags, 16)) {
            encoder2.writeUnsignedShort(options.serialConsistency, dest);
        }
        if (Flags.contains(options.flags, 32)) {
            encoder2.writeLong(options.defaultTimestamp, dest);
        }
        if (Flags.contains(options.flags, 128)) {
            encoder2.writeString(options.keyspace, dest);
        }
        if (options instanceof DseQueryOptions && (continuousPagingOptions = ((DseQueryOptions)options).continuousPagingOptions) != null) {
            encoder2.writeInt(continuousPagingOptions.maxPages, dest);
            encoder2.writeInt(continuousPagingOptions.pagesPerSecond, dest);
            if (this.protocolVersion >= 66) {
                encoder2.writeInt(continuousPagingOptions.nextPages, dest);
            }
        }
    }

    @Override
    public int encodedSize(QueryOptions options) {
        ContinuousPagingOptions continuousPagingOptions;
        int size2 = 6;
        if (Flags.contains(options.flags, 1)) {
            size2 = Flags.contains(options.flags, 64) ? (size2 += Values.sizeOfNamedValues(options.namedValues)) : (size2 += Values.sizeOfPositionalValues(options.positionalValues));
        }
        if (Flags.contains(options.flags, 4)) {
            size2 += 4;
        }
        if (Flags.contains(options.flags, 8)) {
            size2 += PrimitiveSizes.sizeOfBytes(options.pagingState);
        }
        if (Flags.contains(options.flags, 16)) {
            size2 += 2;
        }
        if (Flags.contains(options.flags, 32)) {
            size2 += 8;
        }
        if (Flags.contains(options.flags, 128)) {
            size2 += PrimitiveSizes.sizeOfString(options.keyspace);
        }
        if (options instanceof DseQueryOptions && (continuousPagingOptions = ((DseQueryOptions)options).continuousPagingOptions) != null) {
            size2 += 4 * (this.protocolVersion >= 66 ? 3 : 2);
        }
        return size2;
    }

    @Override
    public <B> QueryOptions decode(B source, PrimitiveCodec<B> decoder2) {
        int consistency2 = decoder2.readUnsignedShort(source);
        int flags2 = this.protocolVersion >= 5 ? decoder2.readInt(source) : (int)decoder2.readByte(source);
        List<ByteBuffer> positionalValues = Collections.emptyList();
        Map<String, ByteBuffer> namedValues = Collections.emptyMap();
        if (Flags.contains(flags2, 1)) {
            if (Flags.contains(flags2, 64)) {
                namedValues = Values.readNamedValues(source, decoder2);
            } else {
                positionalValues = Values.readPositionalValues(source, decoder2);
            }
        }
        boolean skipMetadata = Flags.contains(flags2, 2);
        int pageSize = Flags.contains(flags2, 4) ? decoder2.readInt(source) : -1;
        ByteBuffer pagingState = Flags.contains(flags2, 8) ? decoder2.readBytes(source) : null;
        int serialConsistency2 = Flags.contains(flags2, 16) ? decoder2.readUnsignedShort(source) : 8;
        long defaultTimestamp = Flags.contains(flags2, 32) ? decoder2.readLong(source) : Long.MIN_VALUE;
        String keyspace = Flags.contains(flags2, 128) ? decoder2.readString(source) : null;
        boolean isPageSizeInBytes = Flags.contains(flags2, 0x40000000);
        ContinuousPagingOptions continuousPagingOptions = null;
        if (Flags.contains(flags2, Integer.MIN_VALUE)) {
            int maxPages = decoder2.readInt(source);
            int pagesPerSecond = decoder2.readInt(source);
            int nextPages = this.protocolVersion >= 66 ? decoder2.readInt(source) : -1;
            continuousPagingOptions = new ContinuousPagingOptions(maxPages, pagesPerSecond, nextPages);
        }
        return new DseQueryOptions(flags2, consistency2, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, isPageSizeInBytes, continuousPagingOptions);
    }
}

