/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request.query;

import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class DseQueryOptions
extends QueryOptions {
    public final boolean isPageSizeInBytes;
    public final ContinuousPagingOptions continuousPagingOptions;

    public DseQueryOptions(int consistency2, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency2, long defaultTimestamp, String keyspace, boolean isPageSizeInBytes, ContinuousPagingOptions continuousPagingOptions) {
        this(DseQueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, isPageSizeInBytes, continuousPagingOptions), consistency2, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, isPageSizeInBytes, continuousPagingOptions);
    }

    protected static int computeFlags(List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency2, long defaultTimestamp, String keyspace, boolean isPageSizeInBytes, ContinuousPagingOptions continuousPagingOptions) {
        int flags2 = QueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, Integer.MIN_VALUE);
        if (isPageSizeInBytes) {
            flags2 = Flags.add(flags2, 0x40000000);
        }
        if (continuousPagingOptions != null) {
            flags2 = Flags.add(flags2, Integer.MIN_VALUE);
        }
        return flags2;
    }

    public DseQueryOptions(int flags2, int consistency2, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency2, long defaultTimestamp, String keyspace, boolean isPageSizeInBytes, ContinuousPagingOptions continuousPagingOptions) {
        super(flags2, consistency2, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, Integer.MIN_VALUE);
        this.isPageSizeInBytes = isPageSizeInBytes;
        this.continuousPagingOptions = continuousPagingOptions;
    }
}

