/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.Prepare;

public class DsePrepareCodec
extends Message.Codec {
    public DsePrepareCodec(int protocolVersion) {
        super(9, protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
        Prepare prepare2 = (Prepare)message;
        encoder2.writeLongString(prepare2.cqlQuery, dest);
        if (this.protocolVersion >= 66) {
            encoder2.writeInt(prepare2.keyspace == null ? 0 : 1, dest);
            if (prepare2.keyspace != null) {
                encoder2.writeString(prepare2.keyspace, dest);
            }
        }
    }

    @Override
    public int encodedSize(Message message) {
        Prepare prepare2 = (Prepare)message;
        int size2 = PrimitiveSizes.sizeOfLongString(prepare2.cqlQuery);
        if (this.protocolVersion >= 66) {
            size2 += 4;
            if (prepare2.keyspace != null) {
                size2 += PrimitiveSizes.sizeOfString(prepare2.keyspace);
            }
        }
        return size2;
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
        int flags2;
        String cqlQuery = decoder2.readLongString(source);
        String keyspace = null;
        if (this.protocolVersion >= 66 && ((flags2 = decoder2.readInt(source)) & 1) == 1) {
            keyspace = decoder2.readString(source);
        }
        return new Prepare(cqlQuery, keyspace);
    }
}

