/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.dse.protocol.internal.request.query.DseQueryOptionsCodec;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.Execute;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;

public class DseExecuteCodec
extends Message.Codec {
    private final QueryOptions.Codec optionsCodec;

    public DseExecuteCodec(int protocolVersion) {
        super(10, protocolVersion);
        assert (protocolVersion >= 65);
        this.optionsCodec = new DseQueryOptionsCodec(protocolVersion);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
        Execute execute2 = (Execute)message;
        encoder2.writeShortBytes(execute2.queryId, dest);
        if (this.protocolVersion >= 66) {
            encoder2.writeShortBytes(execute2.resultMetadataId, dest);
        }
        this.optionsCodec.encode(dest, execute2.options, encoder2);
    }

    @Override
    public int encodedSize(Message message) {
        Execute execute2 = (Execute)message;
        int size2 = PrimitiveSizes.sizeOfShortBytes(execute2.queryId);
        if (this.protocolVersion >= 66) {
            assert (execute2.resultMetadataId != null);
            size2 += PrimitiveSizes.sizeOfShortBytes(execute2.resultMetadataId);
        }
        return size2 += this.optionsCodec.encodedSize(execute2.options);
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
        byte[] queryId = decoder2.readShortBytes(source);
        byte[] resultMetadataId = this.protocolVersion >= 66 ? decoder2.readShortBytes(source) : null;
        QueryOptions options = this.optionsCodec.decode(source, decoder2);
        return new Execute(queryId, resultMetadataId, options);
    }
}

