/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.Batch;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DseBatchCodec
extends Message.Codec {
    public DseBatchCodec(int protocolVersion) {
        super(13, protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
        Batch batch2 = (Batch)message;
        encoder2.writeByte(batch2.type, dest);
        int queryCount = batch2.queriesOrIds.size();
        encoder2.writeUnsignedShort(queryCount, dest);
        for (int i = 0; i < queryCount; ++i) {
            Object q = batch2.queriesOrIds.get(i);
            if (q instanceof String) {
                encoder2.writeByte((byte)0, dest);
                encoder2.writeLongString((String)q, dest);
            } else {
                encoder2.writeByte((byte)1, dest);
                encoder2.writeShortBytes((byte[])q, dest);
            }
            Values.writePositionalValues(batch2.values.get(i), dest, encoder2);
        }
        encoder2.writeUnsignedShort(batch2.consistency, dest);
        encoder2.writeInt(batch2.flags, dest);
        if (Flags.contains(batch2.flags, 16)) {
            encoder2.writeUnsignedShort(batch2.serialConsistency, dest);
        }
        if (Flags.contains(batch2.flags, 32)) {
            encoder2.writeLong(batch2.defaultTimestamp, dest);
        }
        if (Flags.contains(batch2.flags, 128)) {
            encoder2.writeString(batch2.keyspace, dest);
        }
    }

    @Override
    public int encodedSize(Message message) {
        Batch batch2 = (Batch)message;
        int size2 = 1;
        size2 += 2;
        int queryCount = batch2.queriesOrIds.size();
        ProtocolErrors.check(queryCount <= 65535, "Batch messages can contain at most %d queries", 65535);
        ProtocolErrors.check(batch2.values.size() == queryCount, "Batch contains %d queries but %d value lists", queryCount, batch2.values.size());
        for (int i = 0; i < queryCount; ++i) {
            Object q = batch2.queriesOrIds.get(i);
            size2 += 1 + (q instanceof String ? PrimitiveSizes.sizeOfLongString((String)q) : PrimitiveSizes.sizeOfShortBytes((byte[])q));
            size2 += Values.sizeOfPositionalValues(batch2.values.get(i));
        }
        size2 += 6;
        if (Flags.contains(batch2.flags, 16)) {
            size2 += 2;
        }
        if (Flags.contains(batch2.flags, 32)) {
            size2 += 8;
        }
        if (Flags.contains(batch2.flags, 128)) {
            size2 += PrimitiveSizes.sizeOfString(batch2.keyspace);
        }
        return size2;
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
        byte type = decoder2.readByte(source);
        int queryCount = decoder2.readUnsignedShort(source);
        ArrayList<Object> queriesOrIds = new ArrayList<Object>();
        ArrayList<List<ByteBuffer>> values2 = new ArrayList<List<ByteBuffer>>();
        for (int i = 0; i < queryCount; ++i) {
            boolean isQueryString = decoder2.readByte(source) == 0;
            queriesOrIds.add(isQueryString ? decoder2.readLongString(source) : (Object)decoder2.readShortBytes(source));
            values2.add(Values.readPositionalValues(source, decoder2));
        }
        int consistency2 = decoder2.readUnsignedShort(source);
        int flags2 = decoder2.readInt(source);
        int serialConsistency2 = Flags.contains(flags2, 16) ? decoder2.readUnsignedShort(source) : 8;
        long defaultTimestamp = Flags.contains(flags2, 32) ? decoder2.readLong(source) : Long.MIN_VALUE;
        String keyspace = Flags.contains(flags2, 128) ? decoder2.readString(source) : null;
        return new Batch(flags2, type, queriesOrIds, values2, consistency2, serialConsistency2, defaultTimestamp, keyspace, Integer.MIN_VALUE);
    }
}

