/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.api.core.type.DseDataTypes;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.dse.driver.internal.core.type.codec.geometry.GeometryCodec;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.esri.core.geometry.ogc.OGCPolygon;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PolygonCodec
extends GeometryCodec<Polygon> {
    private static final GenericType<Polygon> JAVA_TYPE = GenericType.of(Polygon.class);

    @Override
    @NonNull
    public GenericType<Polygon> getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DseDataTypes.POLYGON;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Polygon.class;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Polygon;
    }

    @Override
    @NonNull
    protected Polygon fromWellKnownText(@NonNull String source) {
        return new DefaultPolygon(DefaultGeometry.fromOgcWellKnownText(source, OGCPolygon.class));
    }

    @Override
    @NonNull
    protected Polygon fromWellKnownBinary(@NonNull ByteBuffer bb) {
        return new DefaultPolygon(DefaultGeometry.fromOgcWellKnownBinary(bb, OGCPolygon.class));
    }

    @Override
    @NonNull
    protected String toWellKnownText(@NonNull Polygon geometry) {
        return geometry.asWellKnownText();
    }

    @Override
    @NonNull
    protected ByteBuffer toWellKnownBinary(@NonNull Polygon geometry) {
        return geometry.asWellKnownBinary();
    }
}

