/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.protocol;

import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;

public class TinkerpopBufferPrimitiveCodec
implements PrimitiveCodec<Buffer> {
    private final DseNettyBufferFactory factory;

    public TinkerpopBufferPrimitiveCodec(DseNettyBufferFactory factory) {
        this.factory = factory;
    }

    @Override
    public Buffer allocate(int size2) {
        return this.factory.io(size2, size2);
    }

    @Override
    public void release(Buffer toRelease) {
        toRelease.release();
    }

    @Override
    public int sizeOf(Buffer toMeasure) {
        return toMeasure.readableBytes();
    }

    @Override
    public Buffer concat(Buffer left, Buffer right) {
        boolean rightReadable;
        boolean leftReadable = left.readableBytes() > 0;
        boolean bl = rightReadable = right.readableBytes() > 0;
        if (!leftReadable && !rightReadable) {
            return this.factory.heap();
        }
        if (!leftReadable) {
            return right;
        }
        if (!rightReadable) {
            return left;
        }
        Buffer rv = this.factory.composite(left, right);
        rv.writerIndex(left.writerIndex() - left.readerIndex() + right.writerIndex() - right.readerIndex());
        return rv;
    }

    @Override
    public void markReaderIndex(Buffer source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetReaderIndex(Buffer source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte(Buffer source) {
        return source.readByte();
    }

    @Override
    public int readInt(Buffer source) {
        return source.readInt();
    }

    @Override
    public int readInt(Buffer source, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetAddress readInetAddr(Buffer source) {
        int length = this.readByte(source) & 0xFF;
        byte[] bytes2 = new byte[length];
        source.readBytes(bytes2);
        return TinkerpopBufferPrimitiveCodec.newInetAddress(bytes2);
    }

    @Override
    public long readLong(Buffer source) {
        return source.readLong();
    }

    @Override
    public int readUnsignedShort(Buffer source) {
        return source.readShort() & 0xFFFF;
    }

    @Override
    public ByteBuffer readBytes(Buffer source) {
        int length = this.readInt(source);
        if (length < 0) {
            return null;
        }
        return source.nioBuffer(source.readerIndex(), length);
    }

    @Override
    public byte[] readShortBytes(Buffer source) {
        try {
            int length = this.readUnsignedShort(source);
            byte[] bytes2 = new byte[length];
            source.readBytes(bytes2);
            return bytes2;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not enough bytes to read a byte array preceded by its 2 bytes length");
        }
    }

    @Override
    public String readString(Buffer source) {
        int length = this.readUnsignedShort(source);
        return TinkerpopBufferPrimitiveCodec.readString(source, length);
    }

    @Override
    public String readLongString(Buffer source) {
        int length = this.readInt(source);
        return TinkerpopBufferPrimitiveCodec.readString(source, length);
    }

    @Override
    public Buffer readRetainedSlice(Buffer source, int sliceLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCrc(Buffer source, CRC32 crc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeByte(byte b, Buffer dest) {
        dest.writeByte(b);
    }

    @Override
    public void writeInt(int i, Buffer dest) {
        dest.writeInt(i);
    }

    @Override
    public void writeInetAddr(InetAddress address, Buffer dest) {
        byte[] bytes2 = address.getAddress();
        this.writeByte((byte)bytes2.length, dest);
        dest.writeBytes(bytes2);
    }

    @Override
    public void writeLong(long l, Buffer dest) {
        dest.writeLong(l);
    }

    @Override
    public void writeUnsignedShort(int i, Buffer dest) {
        dest.writeShort(i);
    }

    @Override
    public void writeString(String s2, Buffer dest) {
        byte[] bytes2 = s2.getBytes(Charsets.UTF_8);
        this.writeUnsignedShort(bytes2.length, dest);
        dest.writeBytes(bytes2);
    }

    @Override
    public void writeLongString(String s2, Buffer dest) {
        byte[] bytes2 = s2.getBytes(Charsets.UTF_8);
        this.writeInt(bytes2.length, dest);
        dest.writeBytes(bytes2);
    }

    @Override
    public void writeBytes(ByteBuffer bytes2, Buffer dest) {
        if (bytes2 == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes2.remaining(), dest);
            dest.writeBytes(bytes2.duplicate());
        }
    }

    @Override
    public void writeBytes(byte[] bytes2, Buffer dest) {
        if (bytes2 == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes2.length, dest);
            dest.writeBytes(bytes2);
        }
    }

    @Override
    public void writeShortBytes(byte[] bytes2, Buffer dest) {
        this.writeUnsignedShort(bytes2.length, dest);
        dest.writeBytes(bytes2);
    }

    private static String readString(Buffer buff, int length) {
        try {
            int offset;
            byte[] bytes2;
            ByteBuffer byteBuff = buff.nioBuffer();
            if (byteBuff.hasArray()) {
                bytes2 = byteBuff.array();
                offset = byteBuff.arrayOffset();
            } else {
                bytes2 = new byte[length];
                byteBuff.get(bytes2, 0, length);
                offset = 0;
            }
            String str = new String(bytes2, offset, length, Charsets.UTF_8);
            buff.readerIndex(buff.readerIndex() + length);
            return str;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not enough bytes to read an UTF-8 serialized string of size " + length, e);
        }
    }

    private static InetAddress newInetAddress(byte[] bytes2) {
        try {
            return InetAddress.getByAddress(bytes2);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid address length: %d (%s)", bytes2.length, Arrays.toString(bytes2)));
        }
    }
}

