/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema.parsing;

import com.datastax.dse.driver.api.core.metadata.schema.DseViewMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseColumnMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseViewMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RawColumn;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseViewParser
extends RelationParser {
    private static final Logger LOG = LoggerFactory.getLogger(DseViewParser.class);

    public DseViewParser(SchemaRows rows, InternalDriverContext context) {
        super(rows, context);
    }

    public DseViewMetadata parseView(AdminRow viewRow, CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> userTypes) {
        Map<CqlIdentifier, Object> options;
        CqlIdentifier viewId = CqlIdentifier.fromInternal(viewRow.getString("view_name"));
        UUID uuid = viewRow.getUuid("id");
        CqlIdentifier baseTableId = CqlIdentifier.fromInternal(viewRow.getString("base_table_name"));
        boolean includesAllColumns = MoreObjects.firstNonNull(viewRow.getBoolean("include_all_columns"), false);
        String whereClause = viewRow.getString("where_clause");
        List<RawColumn> rawColumns = RawColumn.toRawColumns(((Multimap)this.rows.columns().getOrDefault(keyspaceId, ImmutableMultimap.of())).get(viewId));
        if (rawColumns.isEmpty()) {
            LOG.warn("[{}] Processing VIEW refresh for {}.{} but found no matching rows, skipping", this.logPrefix, keyspaceId, viewId);
            return null;
        }
        Collections.sort(rawColumns);
        ImmutableMap.Builder<CqlIdentifier, DefaultDseColumnMetadata> allColumnsBuilder = ImmutableMap.builder();
        ImmutableList.Builder partitionKeyBuilder = ImmutableList.builder();
        ImmutableMap.Builder<DefaultDseColumnMetadata, ClusteringOrder> clusteringColumnsBuilder = ImmutableMap.builder();
        for (RawColumn raw2 : rawColumns) {
            DataType dataType = this.rows.dataTypeParser().parse(keyspaceId, raw2.dataType, userTypes, this.context);
            DefaultDseColumnMetadata column = new DefaultDseColumnMetadata(keyspaceId, viewId, raw2.name, dataType, raw2.kind.equals("static"));
            switch (raw2.kind) {
                case "partition_key": {
                    partitionKeyBuilder.add(column);
                    break;
                }
                case "clustering": {
                    clusteringColumnsBuilder.put(column, raw2.reversed ? ClusteringOrder.DESC : ClusteringOrder.ASC);
                    break;
                }
            }
            allColumnsBuilder.put(column.getName(), column);
        }
        try {
            options = this.parseOptions(viewRow);
        }
        catch (Exception e) {
            Loggers.warnWithException(LOG, "[{}] Error while parsing options for {}.{}, getOptions() will be empty", this.logPrefix, keyspaceId, viewId, e);
            options = Collections.emptyMap();
        }
        return new DefaultDseViewMetadata(keyspaceId, viewId, baseTableId, includesAllColumns, whereClause, uuid, (ImmutableList<ColumnMetadata>)partitionKeyBuilder.build(), clusteringColumnsBuilder.build(), allColumnsBuilder.build(), options);
    }
}

