/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseAggregateMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultAggregateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultDseAggregateMetadata
extends DefaultAggregateMetadata
implements DseAggregateMetadata {
    @Nullable
    private final Boolean deterministic;

    public DefaultDseAggregateMetadata(@NonNull CqlIdentifier keyspace, @NonNull FunctionSignature signature2, @Nullable FunctionSignature finalFuncSignature, @Nullable Object initCond, @NonNull DataType returnType, @NonNull FunctionSignature stateFuncSignature, @NonNull DataType stateType, @NonNull TypeCodec<Object> stateTypeCodec, @Nullable Boolean deterministic) {
        super(keyspace, signature2, finalFuncSignature, initCond, returnType, stateFuncSignature, stateType, stateTypeCodec);
        this.deterministic = deterministic;
    }

    @Override
    @Deprecated
    public boolean isDeterministic() {
        return this.deterministic != null && this.deterministic != false;
    }

    @Override
    @Nullable
    public Optional<Boolean> getDeterministic() {
        return Optional.ofNullable(this.deterministic);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DseAggregateMetadata) {
            DseAggregateMetadata that = (DseAggregateMetadata)other;
            return Objects.equals(this.getKeyspace(), that.getKeyspace()) && Objects.equals(this.getSignature(), that.getSignature()) && Objects.equals(this.getFinalFuncSignature().orElse(null), that.getFinalFuncSignature().orElse(null)) && Objects.equals(this.getInitCond().orElse(null), that.getInitCond().orElse(null)) && Objects.equals(this.getReturnType(), that.getReturnType()) && Objects.equals(this.getStateFuncSignature(), that.getStateFuncSignature()) && Objects.equals(this.getStateType(), that.getStateType()) && Objects.equals(this.deterministic, that.getDeterministic().orElse(null));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKeyspace(), this.getSignature(), this.getFinalFuncSignature(), this.getInitCond(), this.getReturnType(), this.getStateFuncSignature(), this.getStateType(), this.deterministic);
    }

    @Override
    public String toString() {
        return "Aggregate Name: " + this.getSignature().getName().asCql(false) + ", Keyspace: " + this.getKeyspace().asCql(false) + ", Return Type: " + this.getReturnType().asCql(false, false) + ", Deterministic: " + this.deterministic;
    }
}

