/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class InsightsPlatformInfo {
    @JsonProperty(value="os")
    private final OS os;
    @JsonProperty(value="cpus")
    private CPUS cpus;
    @JsonProperty(value="runtime")
    private Map<String, Map<String, RuntimeAndCompileTimeVersions>> runtime;

    @JsonCreator
    public InsightsPlatformInfo(@JsonProperty(value="os") OS os, @JsonProperty(value="cpus") CPUS cpus, @JsonProperty(value="runtime") Map<String, Map<String, RuntimeAndCompileTimeVersions>> runtime) {
        this.os = os;
        this.cpus = cpus;
        this.runtime = runtime;
    }

    public OS getOs() {
        return this.os;
    }

    public CPUS getCpus() {
        return this.cpus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsightsPlatformInfo)) {
            return false;
        }
        InsightsPlatformInfo that = (InsightsPlatformInfo)o;
        return Objects.equals(this.os, that.os) && Objects.equals(this.cpus, that.cpus) && Objects.equals(this.runtime, that.runtime);
    }

    public int hashCode() {
        return Objects.hash(this.os, this.cpus, this.runtime);
    }

    Map<String, Map<String, RuntimeAndCompileTimeVersions>> getRuntime() {
        return this.runtime;
    }

    public static class RuntimeAndCompileTimeVersions {
        @JsonProperty(value="runtimeVersion")
        private final String runtimeVersion;
        @JsonProperty(value="compileVersion")
        private final String compileVersion;
        @JsonProperty(value="optional")
        private final boolean optional;

        @JsonCreator
        public RuntimeAndCompileTimeVersions(@JsonProperty(value="runtimeVersion") String runtimeVersion, @JsonProperty(value="compileVersion") String compileVersion, @JsonProperty(value="optional") boolean optional) {
            this.runtimeVersion = runtimeVersion;
            this.compileVersion = compileVersion;
            this.optional = optional;
        }

        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public String getCompileVersion() {
            return this.compileVersion;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RuntimeAndCompileTimeVersions)) {
                return false;
            }
            RuntimeAndCompileTimeVersions that = (RuntimeAndCompileTimeVersions)o;
            return this.optional == that.optional && Objects.equals(this.runtimeVersion, that.runtimeVersion) && Objects.equals(this.compileVersion, that.compileVersion);
        }

        public int hashCode() {
            return Objects.hash(this.runtimeVersion, this.compileVersion, this.optional);
        }

        public String toString() {
            return "RuntimeAndCompileTimeVersions{runtimeVersion='" + this.runtimeVersion + '\'' + ", compileVersion='" + this.compileVersion + '\'' + ", optional=" + this.optional + '}';
        }
    }

    public static class CPUS {
        @JsonProperty(value="length")
        private final int length;
        @JsonProperty(value="model")
        private final String model;

        @JsonCreator
        public CPUS(@JsonProperty(value="length") int length, @JsonProperty(value="model") String model) {
            this.length = length;
            this.model = model;
        }

        public int getLength() {
            return this.length;
        }

        public String getModel() {
            return this.model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CPUS)) {
                return false;
            }
            CPUS cpus = (CPUS)o;
            return this.length == cpus.length && Objects.equals(this.model, cpus.model);
        }

        public int hashCode() {
            return Objects.hash(this.length, this.model);
        }
    }

    public static class OS {
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="version")
        private final String version;
        @JsonProperty(value="arch")
        private final String arch;

        @JsonCreator
        public OS(@JsonProperty(value="name") String name2, @JsonProperty(value="version") String version, @JsonProperty(value="arch") String arch) {
            this.name = name2;
            this.version = version;
            this.arch = arch;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getArch() {
            return this.arch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OS)) {
                return false;
            }
            OS os = (OS)o;
            return Objects.equals(this.name, os.name) && Objects.equals(this.version, os.version) && Objects.equals(this.arch, os.arch);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version, this.arch);
        }
    }
}

