/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.schema.InsightsPlatformInfo;
import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;

class PlatformInfoFinder {
    private static final String MAVEN_IGNORE_LINE = "The following files have been resolved:";
    private static final Pattern DEPENDENCY_SPLIT_REGEX = Pattern.compile(":");
    static final String UNVERIFIED_RUNTIME_VERSION = "UNVERIFIED";
    private final Function<DependencyFromFile, URL> propertiesUrlProvider;
    private static final Function<DependencyFromFile, URL> M2_PROPERTIES_PROVIDER = d -> {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            contextClassLoader = PlatformInfoFinder.class.getClassLoader();
        }
        return contextClassLoader.getResource("META-INF/maven/" + ((DependencyFromFile)d).groupId + "/" + ((DependencyFromFile)d).artifactId + "/pom.properties");
    };

    PlatformInfoFinder() {
        this(M2_PROPERTIES_PROVIDER);
    }

    @VisibleForTesting
    PlatformInfoFinder(Function<DependencyFromFile, URL> pomPropertiesUrlProvider) {
        this.propertiesUrlProvider = pomPropertiesUrlProvider;
    }

    InsightsPlatformInfo getInsightsPlatformInfo() {
        InsightsPlatformInfo.OS os = this.getOsInfo();
        InsightsPlatformInfo.CPUS cpus = this.getCpuInfo();
        Map<String, Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeInfo = this.getRuntimeInfo();
        return new InsightsPlatformInfo(os, cpus, runtimeInfo);
    }

    private Map<String, Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> getRuntimeInfo() {
        Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> coreDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/dse/driver/internal/deps.txt"));
        Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> queryBuilderDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/dse/driver/internal/querybuilder/deps.txt"));
        Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> mapperProcessorDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/dse/driver/internal/mapper/processor/deps.txt"));
        Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> mapperRuntimeDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/dse/driver/internal/mapper/deps.txt"));
        LinkedHashMap<String, Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeDependencies = new LinkedHashMap<String, Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>>();
        this.putIfNonEmpty(coreDeps, runtimeDependencies, "core");
        this.putIfNonEmpty(queryBuilderDeps, runtimeDependencies, "query-builder");
        this.putIfNonEmpty(mapperProcessorDeps, runtimeDependencies, "mapper-processor");
        this.putIfNonEmpty(mapperRuntimeDeps, runtimeDependencies, "mapper-runtime");
        this.addJavaVersion(runtimeDependencies);
        return runtimeDependencies;
    }

    private void putIfNonEmpty(Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> moduleDependencies, Map<String, Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeDependencies, String moduleName) {
        if (!moduleDependencies.isEmpty()) {
            runtimeDependencies.put(moduleName, moduleDependencies);
        }
    }

    @VisibleForTesting
    void addJavaVersion(Map<String, Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeDependencies) {
        Package javaPackage = Runtime.class.getPackage();
        LinkedHashMap<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> javaDependencies = new LinkedHashMap<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        javaDependencies.put("version", this.toSameRuntimeAndCompileVersion(javaPackage.getImplementationVersion()));
        javaDependencies.put("vendor", this.toSameRuntimeAndCompileVersion(javaPackage.getImplementationVendor()));
        javaDependencies.put("title", this.toSameRuntimeAndCompileVersion(javaPackage.getImplementationTitle()));
        this.putIfNonEmpty(javaDependencies, runtimeDependencies, "java");
    }

    private InsightsPlatformInfo.RuntimeAndCompileTimeVersions toSameRuntimeAndCompileVersion(String version) {
        return new InsightsPlatformInfo.RuntimeAndCompileTimeVersions(version, version, false);
    }

    @VisibleForTesting
    Map<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> fetchDependenciesFromFile(InputStream inputStream) {
        LinkedHashMap<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions> dependencies = new LinkedHashMap<String, InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        if (inputStream == null) {
            return dependencies;
        }
        try {
            List<DependencyFromFile> dependenciesFromFile = this.extractMavenDependenciesFromFile(inputStream);
            for (DependencyFromFile d : dependenciesFromFile) {
                dependencies.put(this.formatDependencyName(d), this.getRuntimeAndCompileVersion(d));
            }
        }
        catch (IOException e) {
            return dependencies;
        }
        return dependencies;
    }

    private InsightsPlatformInfo.RuntimeAndCompileTimeVersions getRuntimeAndCompileVersion(DependencyFromFile d) {
        URL url = this.propertiesUrlProvider.apply(d);
        if (url == null) {
            return new InsightsPlatformInfo.RuntimeAndCompileTimeVersions(UNVERIFIED_RUNTIME_VERSION, d.getVersion(), d.isOptional());
        }
        Properties properties2 = new Properties();
        try {
            properties2.load(url.openStream());
        }
        catch (IOException e) {
            return new InsightsPlatformInfo.RuntimeAndCompileTimeVersions(UNVERIFIED_RUNTIME_VERSION, d.getVersion(), d.isOptional());
        }
        Object version = properties2.get("version");
        if (version == null) {
            return new InsightsPlatformInfo.RuntimeAndCompileTimeVersions(UNVERIFIED_RUNTIME_VERSION, d.getVersion(), d.isOptional());
        }
        return new InsightsPlatformInfo.RuntimeAndCompileTimeVersions(version.toString(), d.getVersion(), d.isOptional());
    }

    private String formatDependencyName(DependencyFromFile d) {
        return String.format("%s:%s", d.getGroupId(), d.getArtifactId());
    }

    private List<DependencyFromFile> extractMavenDependenciesFromFile(InputStream inputStream) throws IOException {
        String line;
        ArrayList<DependencyFromFile> dependenciesFromFile = new ArrayList<DependencyFromFile>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (!this.lineWithDependencyInfo(line)) continue;
            dependenciesFromFile.add(this.extractDependencyFromLine(line.trim()));
        }
        return dependenciesFromFile;
    }

    private DependencyFromFile extractDependencyFromLine(String line) {
        String[] split2 = DEPENDENCY_SPLIT_REGEX.split(line);
        if (split2.length == 6) {
            return new DependencyFromFile(split2[0], split2[1], split2[4], this.checkIsOptional(split2[5]));
        }
        return new DependencyFromFile(split2[0], split2[1], split2[3], this.checkIsOptional(split2[4]));
    }

    private boolean checkIsOptional(String scope) {
        return scope.contains("(optional)");
    }

    private boolean lineWithDependencyInfo(String line) {
        return !line.equals(MAVEN_IGNORE_LINE) && !line.isEmpty();
    }

    private InsightsPlatformInfo.CPUS getCpuInfo() {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        String model = Native.getCpu();
        return new InsightsPlatformInfo.CPUS(numberOfProcessors, model);
    }

    private InsightsPlatformInfo.OS getOsInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return new InsightsPlatformInfo.OS(osName, osVersion, osArch);
    }

    static class DependencyFromFile {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final boolean optional;

        DependencyFromFile(String groupId, String artifactId, String version, boolean optional) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.optional = optional;
        }

        String getGroupId() {
            return this.groupId;
        }

        String getArtifactId() {
            return this.artifactId;
        }

        String getVersion() {
            return this.version;
        }

        boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DependencyFromFile)) {
                return false;
            }
            DependencyFromFile that = (DependencyFromFile)o;
            return this.optional == that.optional && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.version, this.optional);
        }

        public String toString() {
            return "DependencyFromFile{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", optional=" + this.optional + '}';
        }
    }
}

