/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import java.util.Arrays;
import java.util.regex.Pattern;

class PackageUtil {
    static final String DEFAULT_SPECULATIVE_EXECUTION_PACKAGE = "com.datastax.oss.driver.internal.core.specex";
    static final String DEFAULT_LOAD_BALANCING_PACKAGE = "com.datastax.oss.driver.internal.core.loadbalancing";
    static final String DEFAULT_AUTH_PROVIDER_PACKAGE = "com.datastax.oss.driver.internal.core.auth";
    private static final Pattern PACKAGE_SPLIT_REGEX = Pattern.compile("\\.");
    private static final Joiner DOT_JOINER = Joiner.on(".");

    PackageUtil() {
    }

    static String getNamespace(Class<?> tClass) {
        String namespace = "";
        Package packageInfo = tClass.getPackage();
        if (packageInfo != null) {
            namespace = packageInfo.getName();
        }
        return namespace;
    }

    static ClassSettingDetails getSpeculativeExecutionDetails(String classSetting) {
        return PackageUtil.getClassSettingDetails(classSetting, DEFAULT_SPECULATIVE_EXECUTION_PACKAGE);
    }

    static ClassSettingDetails getLoadBalancingDetails(String classSetting) {
        return PackageUtil.getClassSettingDetails(classSetting, DEFAULT_LOAD_BALANCING_PACKAGE);
    }

    static ClassSettingDetails getAuthProviderDetails(String classSetting) {
        return PackageUtil.getClassSettingDetails(classSetting, DEFAULT_AUTH_PROVIDER_PACKAGE);
    }

    private static ClassSettingDetails getClassSettingDetails(String classSetting, String packageName) {
        String className2 = PackageUtil.getClassName(classSetting);
        String fullPackage = PackageUtil.getFullPackageOrDefault(classSetting, packageName);
        return new ClassSettingDetails(className2, fullPackage);
    }

    @VisibleForTesting
    static String getClassName(String classSetting) {
        String[] split2 = PACKAGE_SPLIT_REGEX.split(classSetting);
        if (split2.length == 0) {
            return "";
        }
        return split2[split2.length - 1];
    }

    @VisibleForTesting
    static String getFullPackageOrDefault(String classSetting, String defaultValue2) {
        String[] split2 = PACKAGE_SPLIT_REGEX.split(classSetting);
        if (split2.length <= 1) {
            return defaultValue2;
        }
        return DOT_JOINER.join(Arrays.copyOf(split2, split2.length - 1));
    }

    static class ClassSettingDetails {
        private final String className;
        private final String fullPackage;

        ClassSettingDetails(String className2, String fullPackage) {
            this.className = className2;
            this.fullPackage = fullPackage;
        }

        String getClassName() {
            return this.className;
        }

        String getFullPackage() {
            return this.fullPackage;
        }
    }
}

