/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.reactive;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.reactive.ReactiveGraphNode;
import com.datastax.dse.driver.internal.core.cql.reactive.ReactiveOperators;
import com.datastax.dse.driver.internal.core.graph.reactive.DefaultReactiveGraphNode;
import com.datastax.dse.driver.internal.core.util.concurrent.BoundedConcurrentQueue;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReactiveGraphResultSetSubscription
implements Subscription {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveGraphResultSetSubscription.class);
    private static final int MAX_ENQUEUED_PAGES = 4;
    private final AtomicLong requested = new AtomicLong(0L);
    private final BoundedConcurrentQueue<Page> pages = new BoundedConcurrentQueue(4);
    private final AtomicInteger draining = new AtomicInteger(0);
    private final CompletableFuture<Void> firstSubscriberRequestArrived = new CompletableFuture();
    private volatile Subscriber<? super ReactiveGraphNode> mainSubscriber;
    private volatile Subscriber<ExecutionInfo> executionInfosSubscriber;
    private volatile boolean cancelled = false;

    ReactiveGraphResultSetSubscription(@NonNull Subscriber<? super ReactiveGraphNode> mainSubscriber, @NonNull Subscriber<ExecutionInfo> executionInfosSubscriber) {
        this.mainSubscriber = mainSubscriber;
        this.executionInfosSubscriber = executionInfosSubscriber;
    }

    void start(@NonNull Callable<CompletionStage<AsyncGraphResultSet>> firstPage) {
        this.firstSubscriberRequestArrived.thenAccept(aVoid -> this.fetchNextPageAndEnqueue(new Page(firstPage)));
    }

    @Override
    public void request(long n) {
        if (!this.cancelled) {
            if (n < 1L) {
                this.doOnError(new IllegalArgumentException(this.mainSubscriber + " violated the Reactive Streams rule 3.9 by requesting a non-positive number of elements."));
            } else {
                ReactiveOperators.addCap(this.requested, n);
                if (!this.firstSubscriberRequestArrived.isDone()) {
                    this.firstSubscriberRequestArrived.complete(null);
                }
                this.drain();
            }
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (this.draining.getAndIncrement() == 0) {
                this.clear();
            }
        }
    }

    private void drain() {
        if (this.draining.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        do {
            long emitted;
            long r = this.requested.get();
            for (emitted = 0L; emitted != r; ++emitted) {
                Object result2;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                try {
                    result2 = this.tryNext();
                }
                catch (Throwable t) {
                    this.doOnError(t);
                    this.clear();
                    return;
                }
                if (result2 == null) break;
                if (result2 instanceof Throwable) {
                    this.doOnError((Throwable)result2);
                    this.clear();
                    return;
                }
                this.doOnNext((ReactiveGraphNode)result2);
            }
            if (this.isExhausted()) {
                this.doOnComplete();
                this.clear();
                return;
            }
            if (this.cancelled) {
                this.clear();
                return;
            }
            if (emitted == 0L) continue;
            ReactiveOperators.subCap(this.requested, emitted);
        } while ((missed = this.draining.addAndGet(-missed)) != 0);
    }

    @Nullable
    private Object tryNext() {
        Page current = this.pages.peek();
        if (current != null) {
            if (current.hasMoreRows()) {
                return current.nextRow();
            }
            if (current.hasMorePages()) {
                if (this.pages.poll() == null) {
                    throw new AssertionError((Object)"Queue is empty, this should not happen");
                }
                current = this.pages.peek();
                if (current != null && current.hasMoreRows()) {
                    return current.nextRow();
                }
            }
        }
        return null;
    }

    private boolean isExhausted() {
        Page current = this.pages.peek();
        return current != null && !current.hasMoreRows() && !current.hasMorePages();
    }

    private void fetchNextPageAndEnqueue(@NonNull Page current) {
        current.fetchNextPage().handle((rs, t) -> {
            Page page;
            if (t == null) {
                page = this.toPage((AsyncGraphResultSet)rs);
                this.executionInfosSubscriber.onNext(rs.getRequestExecutionInfo());
                if (!page.hasMorePages()) {
                    this.executionInfosSubscriber.onComplete();
                }
            } else {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                page = this.toErrorPage((Throwable)t);
                this.executionInfosSubscriber.onError((Throwable)t);
            }
            return page;
        }).thenCompose(this.pages::offer).thenAccept(page -> {
            if (page.hasMorePages() && !this.cancelled) {
                this.fetchNextPageAndEnqueue((Page)page);
            }
            this.drain();
        });
    }

    private void doOnNext(@NonNull ReactiveGraphNode result2) {
        try {
            this.mainSubscriber.onNext(result2);
        }
        catch (Throwable t) {
            LOG.error(this.mainSubscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onNext.", t);
            this.cancel();
        }
    }

    private void doOnComplete() {
        try {
            this.mainSubscriber.onComplete();
        }
        catch (Throwable t) {
            LOG.error(this.mainSubscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onComplete.", t);
        }
        this.cancel();
    }

    void doOnError(@NonNull Throwable error2) {
        try {
            this.mainSubscriber.onError(error2);
        }
        catch (Throwable t) {
            t.addSuppressed(error2);
            LOG.error(this.mainSubscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onError.", t);
        }
        this.cancel();
    }

    private void clear() {
        this.pages.clear();
        this.mainSubscriber = null;
        this.executionInfosSubscriber = null;
    }

    @NonNull
    private Page toPage(@NonNull AsyncGraphResultSet rs) {
        ExecutionInfo executionInfo = rs.getRequestExecutionInfo();
        Iterator results2 = Iterators.transform(rs.currentPage().iterator(), row -> new DefaultReactiveGraphNode(Objects.requireNonNull(row), executionInfo));
        return new Page(results2, rs.hasMorePages() ? rs::fetchNextPage : null);
    }

    @NonNull
    private Page toErrorPage(@NonNull Throwable t) {
        return new Page(Iterators.singletonIterator(t), null);
    }

    static class Page {
        @NonNull
        final Iterator<?> iterator;
        @Nullable
        final Callable<CompletionStage<AsyncGraphResultSet>> nextPage;

        Page(@NonNull Callable<CompletionStage<AsyncGraphResultSet>> nextPage) {
            this.iterator = Collections.emptyIterator();
            this.nextPage = nextPage;
        }

        Page(@NonNull Iterator<?> iterator2, @Nullable Callable<CompletionStage<AsyncGraphResultSet>> nextPage) {
            this.iterator = iterator2;
            this.nextPage = nextPage;
        }

        boolean hasMorePages() {
            return this.nextPage != null;
        }

        @NonNull
        CompletionStage<AsyncGraphResultSet> fetchNextPage() {
            try {
                return Objects.requireNonNull(this.nextPage).call();
            }
            catch (Exception e) {
                return CompletableFutures.failedFuture(e);
            }
        }

        boolean hasMoreRows() {
            return this.iterator.hasNext();
        }

        @NonNull
        Object nextRow() {
            return this.iterator.next();
        }
    }
}

