/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary.buffer;

import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.BufferFactory;

public class DseNettyBufferFactory
implements BufferFactory<ByteBuf> {
    private static ByteBufAllocator DEFAULT_ALLOCATOR = new UnpooledByteBufAllocator(false);
    private final ByteBufAllocator allocator;

    public DseNettyBufferFactory() {
        this.allocator = DEFAULT_ALLOCATOR;
    }

    public DseNettyBufferFactory(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public Buffer create(ByteBuf value2) {
        return new DseNettyBuffer(value2);
    }

    @Override
    public Buffer wrap(ByteBuffer value2) {
        return this.create(Unpooled.wrappedBuffer(value2));
    }

    public Buffer heap() {
        return this.create(this.allocator.heapBuffer());
    }

    public Buffer heap(int initialSize) {
        return this.create(this.allocator.heapBuffer(initialSize));
    }

    public Buffer heap(int initialSize, int maxSize) {
        return this.create(this.allocator.heapBuffer(initialSize, maxSize));
    }

    public Buffer io() {
        return this.create(this.allocator.ioBuffer());
    }

    public Buffer io(int initialSize) {
        return this.create(this.allocator.ioBuffer(initialSize));
    }

    public Buffer io(int initialSize, int maxSize) {
        return this.create(this.allocator.ioBuffer(initialSize, maxSize));
    }

    public Buffer direct() {
        return this.create(this.allocator.directBuffer());
    }

    public Buffer direct(int initialSize) {
        return this.create(this.allocator.directBuffer(initialSize));
    }

    public Buffer direct(int initialSize, int maxSize) {
        return this.create(this.allocator.directBuffer(initialSize, maxSize));
    }

    public Buffer composite(ByteBuf ... components) {
        CompositeByteBuf buff = this.allocator.compositeBuffer(components.length);
        buff.addComponents(components);
        return this.create(buff);
    }

    public Buffer composite(Buffer ... components) {
        ByteBuf[] nettyBufs = new ByteBuf[components.length];
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof DseNettyBuffer)) {
                throw new IllegalArgumentException("Can only concatenate DseNettyBuffer instances");
            }
            nettyBufs[i] = ((DseNettyBuffer)components[i]).getUnderlyingBuffer();
        }
        return this.composite(nettyBufs);
    }

    public Buffer withBytes(int ... bytes2) {
        return this.withBytes(this::heap, bytes2);
    }

    public Buffer withBytes(Supplier<Buffer> supplier, int ... bytes2) {
        Buffer buff = supplier.get();
        for (int val : bytes2) {
            buff.writeByte(val);
        }
        return buff;
    }
}

