/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.internal.core.graph.binary.AbstractDynamicGraphBinaryCustomSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.ComplexTypeSerializerUtil;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class UdtValueSerializer
extends AbstractDynamicGraphBinaryCustomSerializer<UdtValue> {
    private final DefaultDriverContext driverContext;

    public UdtValueSerializer(DefaultDriverContext driverContext) {
        this.driverContext = driverContext;
    }

    @Override
    public String getTypeName() {
        return "driver.core.UDTValue";
    }

    @Override
    public UdtValue readDynamicCustomValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        DataType driverType = ComplexTypeSerializerUtil.decodeTypeDefinition(buffer, this.driverContext);
        assert (driverType instanceof UserDefinedType) : "GraphBinary UdtValue deserializer was called on a value that is not encoded as a UdtValue.";
        UserDefinedType userDefinedType = (UserDefinedType)driverType;
        UdtValue value2 = userDefinedType.newValue();
        return ComplexTypeSerializerUtil.decodeValue(buffer, value2, userDefinedType.getFieldTypes().size());
    }

    @Override
    public void writeDynamicCustomValue(UdtValue value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        ComplexTypeSerializerUtil.encodeTypeDefinition(value2.getType(), buffer, this.driverContext);
        ComplexTypeSerializerUtil.encodeValue(value2, buffer);
    }
}

