/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.internal.core.graph.binary.AbstractDynamicGraphBinaryCustomSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.ComplexTypeSerializerUtil;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class TupleValueSerializer
extends AbstractDynamicGraphBinaryCustomSerializer<TupleValue> {
    private final DefaultDriverContext driverContext;

    public TupleValueSerializer(DefaultDriverContext driverContext) {
        this.driverContext = driverContext;
    }

    @Override
    public String getTypeName() {
        return "driver.core.TupleValue";
    }

    @Override
    public TupleValue readDynamicCustomValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        DataType type = ComplexTypeSerializerUtil.decodeTypeDefinition(buffer, this.driverContext);
        assert (type instanceof TupleType) : "GraphBinary TupleValue deserializer was called on a value that is not encoded as a TupleValue.";
        TupleType tupleType = (TupleType)type;
        TupleValue value2 = tupleType.newValue();
        return ComplexTypeSerializerUtil.decodeValue(buffer, value2, tupleType.getComponentTypes().size());
    }

    @Override
    public void writeDynamicCustomValue(TupleValue value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        ComplexTypeSerializerUtil.encodeTypeDefinition(value2.getType(), buffer, this.driverContext);
        ComplexTypeSerializerUtil.encodeValue(value2, buffer);
    }
}

