/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.internal.core.graph.EditDistance;
import com.datastax.dse.driver.internal.core.graph.binary.AbstractSimpleGraphBinaryCustomSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryUtils;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;

public class EditDistanceSerializer
extends AbstractSimpleGraphBinaryCustomSerializer<EditDistance> {
    @Override
    public String getTypeName() {
        return "driver.dse.search.EditDistance";
    }

    @Override
    protected EditDistance readCustomValue(int valueLength, Buffer buffer, GraphBinaryReader context) throws IOException {
        int distance = context.readValue(buffer, Integer.class, false);
        String query = context.readValue(buffer, String.class, false);
        this.checkValueSize(GraphBinaryUtils.sizeOfEditDistance(query), valueLength);
        return new EditDistance(query, distance);
    }

    @Override
    protected void writeCustomValue(EditDistance value2, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(GraphBinaryUtils.sizeOfEditDistance(value2.query), buffer, false);
        context.writeValue(value2.distance, buffer, false);
        context.writeValue(value2.query, buffer, false);
    }
}

