/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.internal.core.graph.DsePredicate;
import com.datastax.dse.driver.internal.core.graph.EditDistance;
import com.datastax.dse.driver.internal.core.graph.SearchUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SearchPredicate implements DsePredicate
{
    token{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            return value2 != null && this.evaluate(value2.toString(), (String)condition);
        }

        boolean evaluate(String value2, String terms) {
            HashSet<String> tokens = Sets.newHashSet(1.tokenize(value2.toLowerCase()));
            terms = terms.trim();
            List<String> tokenTerms = 1.tokenize(terms.toLowerCase());
            if (!terms.isEmpty() && tokenTerms.isEmpty()) {
                return false;
            }
            for (String term : tokenTerms) {
                if (tokens.contains(term)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && SearchPredicate.isNotBlank((String)condition);
        }

        public String toString() {
            return "token";
        }
    }
    ,
    tokenPrefix{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            return value2 != null && this.evaluate(value2.toString(), (String)condition);
        }

        boolean evaluate(String value2, String prefix) {
            for (String token2 : 2.tokenize(value2.toLowerCase())) {
                if (!token2.startsWith(prefix.toLowerCase().trim())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null;
        }

        public String toString() {
            return "tokenPrefix";
        }
    }
    ,
    tokenRegex{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            return value2 != null && this.evaluate(value2.toString(), (String)condition);
        }

        boolean evaluate(String value2, String regex) {
            Pattern compiled = Pattern.compile(regex, 2);
            for (String token2 : 3.tokenize(value2.toLowerCase())) {
                if (!compiled.matcher(token2).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && SearchPredicate.isNotBlank((String)condition);
        }

        public String toString() {
            return "tokenRegex";
        }
    }
    ,
    tokenFuzzy{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            if (value2 == null) {
                return false;
            }
            EditDistance fuzzyCondition = (EditDistance)condition;
            for (String token2 : 4.tokenize(value2.toString().toLowerCase())) {
                if (SearchUtils.getOptimalStringAlignmentDistance(token2, fuzzyCondition.query.toLowerCase()) > fuzzyCondition.distance) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null;
        }

        public String toString() {
            return "tokenFuzzy";
        }
    }
    ,
    prefix{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            return value2 != null && value2.toString().startsWith(((String)condition).trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null;
        }

        public String toString() {
            return "prefix";
        }
    }
    ,
    regex{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            return value2 != null && Pattern.compile((String)condition, 32).matcher(value2.toString()).matches();
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && SearchPredicate.isNotBlank((String)condition);
        }

        public String toString() {
            return "regex";
        }
    }
    ,
    fuzzy{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            if (value2 == null) {
                return false;
            }
            EditDistance fuzzyCondition = (EditDistance)condition;
            return SearchUtils.getOptimalStringAlignmentDistance(value2.toString(), fuzzyCondition.query) <= fuzzyCondition.distance;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null;
        }

        public String toString() {
            return "fuzzy";
        }
    }
    ,
    phrase{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            if (value2 == null) {
                return false;
            }
            EditDistance phraseCondition = (EditDistance)condition;
            List<String> valueTokens = 8.tokenize(value2.toString().toLowerCase());
            List<String> phraseTokens = 8.tokenize(phraseCondition.query.toLowerCase());
            int phrasePosition = 0;
            int distance = 0;
            for (int valuePosition = 0; phrasePosition < phraseTokens.size() && valuePosition < valueTokens.size() && distance <= phraseCondition.distance; ++valuePosition) {
                if (phraseTokens.get(phrasePosition).equals(valueTokens.get(valuePosition))) {
                    if (phrasePosition == phraseTokens.size() - 1) {
                        return true;
                    }
                    ++phrasePosition;
                    continue;
                }
                if (0 >= phrasePosition) continue;
                ++distance;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null;
        }

        public String toString() {
            return "phrase";
        }
    };

    private static final Pattern TOKEN_SPLIT_PATTERN;

    private static boolean isNotBlank(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static List<String> tokenize(String str) {
        String[] rawTokens = TOKEN_SPLIT_PATTERN.split(str);
        return Stream.of(rawTokens).filter(t -> 0 < t.length()).collect(Collectors.toList());
    }

    static {
        TOKEN_SPLIT_PATTERN = Pattern.compile("[^\\p{L}\\p{Nd}]");
    }
}

