/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.base.Objects;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

@Immutable
public class LegacyGraphNode
implements GraphNode {
    private static final String TYPE = "type";
    private static final String VERTEX_TYPE = "vertex";
    private static final String EDGE_TYPE = "edge";
    private static final GenericType<List<Object>> LIST_TYPE = GenericType.listOf(Object.class);
    private static final GenericType<Map<String, Object>> MAP_TYPE = GenericType.mapOf(String.class, Object.class);
    private final JsonNode delegate;
    private final ObjectMapper objectMapper;

    public LegacyGraphNode(JsonNode delegate, ObjectMapper objectMapper) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(objectMapper);
        this.delegate = delegate;
        this.objectMapper = objectMapper;
    }

    public JsonNode getDelegate() {
        return this.delegate;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public boolean isNull() {
        return this.delegate.isNull();
    }

    @Override
    public boolean isMap() {
        return this.delegate.isObject();
    }

    @Override
    public Iterable<?> keys() {
        return this.delegate::fieldNames;
    }

    @Override
    public LegacyGraphNode getByKey(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        JsonNode node = this.delegate.get((String)key);
        if (node == null) {
            return null;
        }
        return new LegacyGraphNode(node, this.objectMapper);
    }

    @Override
    public <K, V> Map<K, V> asMap() {
        return this.as(MAP_TYPE);
    }

    @Override
    public boolean isList() {
        return this.delegate.isArray();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public LegacyGraphNode getByIndex(int index2) {
        JsonNode node = this.delegate.get(index2);
        if (node == null) {
            return null;
        }
        return new LegacyGraphNode(node, this.objectMapper);
    }

    @Override
    public <T> List<T> asList() {
        return this.as(LIST_TYPE);
    }

    @Override
    public boolean isValue() {
        return this.delegate.isValueNode();
    }

    @Override
    public int asInt() {
        return this.delegate.asInt();
    }

    @Override
    public boolean asBoolean() {
        return this.delegate.asBoolean();
    }

    @Override
    public long asLong() {
        return this.delegate.asLong();
    }

    @Override
    public double asDouble() {
        return this.delegate.asDouble();
    }

    @Override
    public String asString() {
        return this.delegate.asText();
    }

    @Override
    public boolean isVertex() {
        return this.isType(VERTEX_TYPE);
    }

    @Override
    public Vertex asVertex() {
        try {
            return GraphSONUtils.GRAPHSON1_READER.get().readVertex(new ByteArrayInputStream(this.delegate.toString().getBytes(StandardCharsets.UTF_8)), null, null, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not deserialize node as Vertex.", e);
        }
    }

    @Override
    public boolean isEdge() {
        return this.isType(EDGE_TYPE);
    }

    @Override
    public Edge asEdge() {
        try {
            return GraphSONUtils.GRAPHSON1_READER.get().readEdge(new ByteArrayInputStream(this.delegate.toString().getBytes(StandardCharsets.UTF_8)), Attachable::get);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not deserialize node as Edge.", e);
        }
    }

    @Override
    public boolean isPath() {
        return false;
    }

    @Override
    public Path asPath() {
        throw new UnsupportedOperationException("GraphSON1 does not support Path, use another Graph sub-protocol such as GraphSON2.");
    }

    @Override
    public boolean isProperty() {
        return this.delegate.has("key") && this.delegate.has("value");
    }

    @Override
    public <T> Property<T> asProperty() {
        try {
            return GraphSONUtils.GRAPHSON1_READER.get().readProperty(new ByteArrayInputStream(this.delegate.toString().getBytes(StandardCharsets.UTF_8)), Attachable::get);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not deserialize node as Property.", e);
        }
    }

    @Override
    public boolean isVertexProperty() {
        return this.delegate.has("id") && this.delegate.has("value") && this.delegate.has("label");
    }

    @Override
    public <T> VertexProperty<T> asVertexProperty() {
        try {
            return GraphSONUtils.GRAPHSON1_READER.get().readVertexProperty(new ByteArrayInputStream(this.delegate.toString().getBytes(StandardCharsets.UTF_8)), Attachable::get);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not deserialize node as VertexProperty.", e);
        }
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public <T> Set<T> asSet() {
        throw new UnsupportedOperationException("GraphSON1 does not support Set, use another Graph sub-protocol such as GraphSON2.");
    }

    @Override
    public <ResultT> ResultT as(Class<ResultT> clazz2) {
        try {
            return this.objectMapper.treeToValue(this.delegate, clazz2);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not deserialize node as: " + clazz2, e);
        }
    }

    @Override
    public <ResultT> ResultT as(GenericType<ResultT> type) {
        try {
            JsonParser parser2 = this.objectMapper.treeAsTokens(this.delegate);
            JavaType javaType2 = this.objectMapper.constructType(type.__getToken().getType());
            return (ResultT)this.objectMapper.readValue(parser2, javaType2);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not deserialize node as: " + type, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyGraphNode)) {
            return false;
        }
        LegacyGraphNode that = (LegacyGraphNode)o;
        return Objects.equal(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private boolean isType(String expectedTypeName) {
        JsonNode type = this.delegate.get(TYPE);
        return type != null && expectedTypeName.equals(type.asText());
    }
}

