/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.PagingEnabledOptions;
import com.datastax.dse.driver.internal.core.DseProtocolFeature;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSupportChecker {
    private static final Logger LOG = LoggerFactory.getLogger(GraphSupportChecker.class);
    private static final Version MIN_DSE_VERSION_GRAPH_BINARY_AND_PAGING = Objects.requireNonNull(Version.parse("6.8.0"));
    private volatile Boolean contextGraphPagingEnabled;
    private volatile Boolean isDse68OrAbove;

    public boolean isPagingEnabled(@NonNull GraphStatement<?> graphStatement, @NonNull InternalDriverContext context) {
        DriverExecutionProfile driverExecutionProfile = Conversions.resolveExecutionProfile(graphStatement, context);
        PagingEnabledOptions pagingEnabledOptions = PagingEnabledOptions.valueOf(driverExecutionProfile.getString(DseDriverOption.GRAPH_PAGING_ENABLED));
        if (LOG.isTraceEnabled()) {
            LOG.trace("GRAPH_PAGING_ENABLED: {}", (Object)pagingEnabledOptions);
        }
        if (pagingEnabledOptions == PagingEnabledOptions.DISABLED) {
            return false;
        }
        if (pagingEnabledOptions == PagingEnabledOptions.ENABLED) {
            return true;
        }
        return this.isContextGraphPagingEnabled(context);
    }

    @NonNull
    public GraphProtocol inferGraphProtocol(@NonNull GraphStatement<?> statement2, @NonNull DriverExecutionProfile config, @NonNull InternalDriverContext context) {
        String graphProtocol = statement2.getSubProtocol();
        if (graphProtocol == null) {
            graphProtocol = config.isDefined(DseDriverOption.GRAPH_SUB_PROTOCOL) ? config.getString(DseDriverOption.GRAPH_SUB_PROTOCOL) : this.getDefaultGraphProtocol(context).toInternalCode();
        }
        Objects.requireNonNull(graphProtocol, "Could not determine the graph protocol for the query. This is a bug, please report.");
        return GraphProtocol.fromString(graphProtocol);
    }

    private boolean isContextGraphPagingEnabled(InternalDriverContext context) {
        if (this.contextGraphPagingEnabled == null) {
            ProtocolVersion protocolVersion = context.getProtocolVersion();
            if (!context.getProtocolVersionRegistry().supports(protocolVersion, DseProtocolFeature.CONTINUOUS_PAGING)) {
                this.contextGraphPagingEnabled = false;
            } else {
                if (this.isDse68OrAbove == null) {
                    this.isDse68OrAbove = this.checkIsDse68OrAbove(context);
                }
                this.contextGraphPagingEnabled = this.isDse68OrAbove;
            }
        }
        return this.contextGraphPagingEnabled;
    }

    @VisibleForTesting
    GraphProtocol getDefaultGraphProtocol(@NonNull InternalDriverContext context) {
        if (this.isDse68OrAbove == null) {
            this.isDse68OrAbove = this.checkIsDse68OrAbove(context);
        }
        return this.isDse68OrAbove != false ? GraphProtocol.GRAPH_BINARY_1_0 : GraphProtocol.GRAPHSON_2_0;
    }

    private boolean checkIsDse68OrAbove(@NonNull InternalDriverContext context) {
        Collection<Node> nodes2 = context.getMetadataManager().getMetadata().getNodes().values();
        for (Node node : nodes2) {
            Version dseVersion = (Version)node.getExtras().get("DSE_VERSION");
            if (dseVersion != null && dseVersion.compareTo(MIN_DSE_VERSION_GRAPH_BINARY_AND_PAGING) >= 0) continue;
            return false;
        }
        return true;
    }
}

