/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class GraphStatementBase<SelfT extends GraphStatement<SelfT>>
implements GraphStatement<SelfT> {
    private final Boolean isIdempotent;
    private final Duration timeout;
    private final Node node;
    private final long timestamp;
    private final DriverExecutionProfile executionProfile;
    private final String executionProfileName;
    private final Map<String, ByteBuffer> customPayload;
    private final String graphName;
    private final String traversalSource;
    private final String subProtocol;
    private final ConsistencyLevel consistencyLevel;
    private final ConsistencyLevel readConsistencyLevel;
    private final ConsistencyLevel writeConsistencyLevel;

    protected GraphStatementBase(Boolean isIdempotent, Duration timeout, Node node, long timestamp2, DriverExecutionProfile executionProfile, String executionProfileName, Map<String, ByteBuffer> customPayload, String graphName, String traversalSource, String subProtocol, ConsistencyLevel consistencyLevel, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        this.isIdempotent = isIdempotent;
        this.timeout = timeout;
        this.node = node;
        this.timestamp = timestamp2;
        this.executionProfile = executionProfile;
        this.executionProfileName = executionProfileName;
        this.customPayload = customPayload;
        this.graphName = graphName;
        this.traversalSource = traversalSource;
        this.subProtocol = subProtocol;
        this.consistencyLevel = consistencyLevel;
        this.readConsistencyLevel = readConsistencyLevel;
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    protected abstract SelfT newInstance(Boolean var1, Duration var2, Node var3, long var4, DriverExecutionProfile var6, String var7, Map<String, ByteBuffer> var8, String var9, String var10, String var11, ConsistencyLevel var12, ConsistencyLevel var13, ConsistencyLevel var14);

    @Override
    public Boolean isIdempotent() {
        return this.isIdempotent;
    }

    @Override
    @NonNull
    public SelfT setIdempotent(@Nullable Boolean newIdempotence) {
        return this.newInstance(newIdempotence, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    @NonNull
    public SelfT setTimeout(@Nullable Duration newTimeout) {
        return this.newInstance(this.isIdempotent, newTimeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public Node getNode() {
        return this.node;
    }

    @Override
    @NonNull
    public SelfT setNode(@Nullable Node newNode) {
        return this.newInstance(this.isIdempotent, this.timeout, newNode, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @NonNull
    public SelfT setTimestamp(long newTimestamp) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, newTimestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public DriverExecutionProfile getExecutionProfile() {
        return this.executionProfile;
    }

    @Override
    @NonNull
    public SelfT setExecutionProfile(@Nullable DriverExecutionProfile newExecutionProfile) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, newExecutionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    @Override
    @NonNull
    public SelfT setExecutionProfileName(@Nullable String newExecutionProfileName) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, newExecutionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getCustomPayload() {
        return this.customPayload;
    }

    @Override
    @NonNull
    public SelfT setCustomPayload(@NonNull Map<String, ByteBuffer> newCustomPayload) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, newCustomPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public String getGraphName() {
        return this.graphName;
    }

    @Override
    @NonNull
    public SelfT setGraphName(@Nullable String newGraphName) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, newGraphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public String getTraversalSource() {
        return this.traversalSource;
    }

    @Override
    @NonNull
    public SelfT setTraversalSource(@Nullable String newTraversalSource) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, newTraversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public String getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    @NonNull
    public SelfT setSubProtocol(@Nullable String newSubProtocol) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, newSubProtocol, this.consistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public SelfT setConsistencyLevel(@Nullable ConsistencyLevel newConsistencyLevel) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, newConsistencyLevel, this.readConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    @Override
    @NonNull
    public SelfT setReadConsistencyLevel(@Nullable ConsistencyLevel newReadConsistencyLevel) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, newReadConsistencyLevel, this.writeConsistencyLevel);
    }

    @Override
    @Nullable
    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    @Override
    @NonNull
    public SelfT setWriteConsistencyLevel(@Nullable ConsistencyLevel newWriteConsistencyLevel) {
        return this.newInstance(this.isIdempotent, this.timeout, this.node, this.timestamp, this.executionProfile, this.executionProfileName, this.customPayload, this.graphName, this.traversalSource, this.subProtocol, this.consistencyLevel, this.readConsistencyLevel, newWriteConsistencyLevel);
    }
}

