/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Queue;
import net.jcip.annotations.NotThreadSafe;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

@NotThreadSafe
class GraphResultIterator
extends CountingIterator<GraphNode> {
    private final Queue<GraphNode> data;
    private final GraphProtocol graphProtocol;
    private long repeat = 0L;
    private GraphNode lastGraphNode = null;

    GraphResultIterator(Queue<GraphNode> data2, GraphProtocol graphProtocol) {
        super(data2.size());
        this.data = data2;
        this.graphProtocol = graphProtocol;
    }

    @Override
    protected GraphNode computeNext() {
        if (this.repeat > 1L) {
            --this.repeat;
            return this.lastGraphNode;
        }
        GraphNode container2 = this.data.poll();
        if (container2 == null) {
            return (GraphNode)this.endOfData();
        }
        if (this.graphProtocol.isGraphBinary()) {
            Preconditions.checkState(container2.as(Object.class) instanceof Traverser, "Graph protocol error. Received object should be a Traverser but it is not.");
            Traverser t = container2.as(Traverser.class);
            this.repeat = t.bulk();
            this.lastGraphNode = new ObjectGraphNode(t.get());
            return this.lastGraphNode;
        }
        GraphNode b = container2.getByKey("bulk");
        if (b != null) {
            this.repeat = b.asLong();
        }
        this.lastGraphNode = container2.getByKey("result");
        return this.lastGraphNode;
    }
}

