/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.graph.DefaultAsyncGraphResultSet;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultExecutionInfo;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.handler.codec.EncoderException;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GraphRequestHandler
implements Throttled {
    private static final Logger LOG = LoggerFactory.getLogger(GraphRequestHandler.class);
    private static final long NANOTIME_NOT_MEASURED_YET = -1L;
    private static final int NO_SUCCESSFUL_EXECUTION = -1;
    private final long startTimeNanos = System.nanoTime();
    private final String logPrefix;
    private final GraphStatement<?> statement;
    private final DefaultSession session;
    private final InternalDriverContext context;
    private final DriverExecutionProfile executionProfile;
    private final boolean isIdempotent;
    protected final CompletableFuture<AsyncGraphResultSet> result;
    private final Message message;
    private final Timer timer;
    private final GraphProtocol subProtocol;
    private final AtomicInteger activeExecutionsCount;
    private final AtomicInteger startedSpeculativeExecutionsCount;
    private final Timeout scheduledTimeout;
    private final List<Timeout> scheduledExecutions;
    private final List<NodeResponseCallback> inFlightCallbacks;
    private final RetryPolicy retryPolicy;
    private final SpeculativeExecutionPolicy speculativeExecutionPolicy;
    private final RequestThrottler throttler;
    private final RequestTracker requestTracker;
    private final SessionMetricUpdater sessionMetricUpdater;
    private final Map<String, ByteBuffer> queryCustomPayload;
    private final GraphBinaryModule graphBinaryModule;
    private volatile List<Map.Entry<Node, Throwable>> errors;

    GraphRequestHandler(@NonNull GraphStatement<?> statement2, @NonNull DefaultSession dseSession, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix, @NonNull GraphBinaryModule graphBinaryModule, @NonNull GraphSupportChecker graphSupportChecker) {
        this.logPrefix = sessionLogPrefix + "|" + this.hashCode();
        LOG.trace("[{}] Creating new Graph request handler for request {}", (Object)this.logPrefix, (Object)statement2);
        this.statement = statement2;
        this.session = dseSession;
        this.context = context;
        this.executionProfile = GraphConversions.resolveExecutionProfile(this.statement, this.context);
        this.retryPolicy = context.getRetryPolicy(this.executionProfile.getName());
        this.speculativeExecutionPolicy = context.getSpeculativeExecutionPolicy(this.executionProfile.getName());
        Boolean statementIsIdempotent = statement2.isIdempotent();
        this.isIdempotent = statementIsIdempotent == null ? this.executionProfile.getBoolean(DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE) : statementIsIdempotent.booleanValue();
        this.result = new CompletableFuture();
        this.result.exceptionally(t -> {
            try {
                if (t instanceof CancellationException) {
                    this.cancelScheduledTasks();
                }
            }
            catch (Throwable t2) {
                Loggers.warnWithException(LOG, "[{}] Uncaught exception", this.logPrefix, t2);
            }
            return null;
        });
        this.graphBinaryModule = graphBinaryModule;
        this.subProtocol = graphSupportChecker.inferGraphProtocol(this.statement, this.executionProfile, this.context);
        LOG.debug("[{}], Graph protocol used for query: {}", (Object)this.logPrefix, (Object)this.subProtocol);
        this.message = GraphConversions.createMessageFromGraphStatement(this.statement, this.subProtocol, this.executionProfile, this.context, this.graphBinaryModule);
        this.timer = context.getNettyOptions().getTimer();
        Duration timeout = statement2.getTimeout() != null ? statement2.getTimeout() : this.executionProfile.getDuration(DseDriverOption.GRAPH_TIMEOUT, null);
        this.scheduledTimeout = this.scheduleTimeout(timeout);
        this.activeExecutionsCount = new AtomicInteger(1);
        this.startedSpeculativeExecutionsCount = new AtomicInteger(0);
        this.scheduledExecutions = this.isIdempotent ? new CopyOnWriteArrayList() : null;
        this.inFlightCallbacks = new CopyOnWriteArrayList<NodeResponseCallback>();
        this.queryCustomPayload = GraphConversions.createCustomPayload(this.statement, this.subProtocol, this.executionProfile, this.context, this.graphBinaryModule);
        this.requestTracker = context.getRequestTracker();
        this.sessionMetricUpdater = this.session.getMetricUpdater();
        this.throttler = context.getRequestThrottler();
        this.throttler.register(this);
    }

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        if (wasDelayed && this.sessionMetricUpdater.isEnabled(DefaultSessionMetric.THROTTLING_DELAY, this.executionProfile.getName())) {
            this.sessionMetricUpdater.updateTimer(DefaultSessionMetric.THROTTLING_DELAY, this.executionProfile.getName(), System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        Queue<Node> queryPlan = this.statement.getNode() != null ? new QueryPlan(this.statement.getNode()) : this.context.getLoadBalancingPolicyWrapper().newQueryPlan(this.statement, this.executionProfile.getName(), this.session);
        this.sendRequest(null, queryPlan, 0, 0, true);
    }

    public CompletionStage<AsyncGraphResultSet> handle() {
        return this.result;
    }

    private Timeout scheduleTimeout(Duration timeoutDuration) {
        if (timeoutDuration != null && timeoutDuration.toNanos() > 0L) {
            try {
                return this.timer.newTimeout(timeout1 -> this.setFinalError(new DriverTimeoutException("Query timed out after " + timeoutDuration), null, -1), timeoutDuration.toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (IllegalStateException e) {
                this.result.completeExceptionally("cannot be started once stopped".equals(e.getMessage()) ? new IllegalStateException("Session is closed") : e);
            }
        }
        return null;
    }

    private void sendRequest(Node retriedNode, Queue<Node> queryPlan, int currentExecutionIndex, int retryCount, boolean scheduleNextExecution) {
        if (this.result.isDone()) {
            return;
        }
        Node node = retriedNode;
        DriverChannel channel = null;
        if (node == null || (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            while (!this.result.isDone() && (node = queryPlan.poll()) != null && (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            }
        }
        if (channel == null) {
            if (!this.result.isDone() && this.activeExecutionsCount.decrementAndGet() == 0) {
                this.setFinalError(AllNodesFailedException.fromErrors(this.errors), null, -1);
            }
        } else {
            NodeResponseCallback nodeResponseCallback = new NodeResponseCallback(node, queryPlan, channel, currentExecutionIndex, retryCount, scheduleNextExecution, this.logPrefix);
            channel.write(this.message, this.statement.isTracing(), this.queryCustomPayload, nodeResponseCallback).addListener(nodeResponseCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Node node, Throwable error2) {
        List<Map.Entry<Node, Throwable>> errorsSnapshot = this.errors;
        if (errorsSnapshot == null) {
            GraphRequestHandler graphRequestHandler = this;
            synchronized (graphRequestHandler) {
                errorsSnapshot = this.errors;
                if (errorsSnapshot == null) {
                    this.errors = errorsSnapshot = new CopyOnWriteArrayList<Map.Entry<Node, Throwable>>();
                }
            }
        }
        errorsSnapshot.add(new AbstractMap.SimpleEntry<Node, Throwable>(node, error2));
    }

    private void cancelScheduledTasks() {
        if (this.scheduledTimeout != null) {
            this.scheduledTimeout.cancel();
        }
        if (this.scheduledExecutions != null) {
            for (Timeout scheduledExecution : this.scheduledExecutions) {
                scheduledExecution.cancel();
            }
        }
        for (NodeResponseCallback callback : this.inFlightCallbacks) {
            callback.cancel();
        }
    }

    private void setFinalResult(Result resultMessage, Frame responseFrame, NodeResponseCallback callback) {
        try {
            ExecutionInfo executionInfo = this.buildExecutionInfo(callback, responseFrame);
            ArrayDeque<GraphNode> graphNodes = new ArrayDeque<GraphNode>();
            for (List list2 : ((Rows)resultMessage).getData()) {
                if (this.subProtocol.isGraphBinary()) {
                    graphNodes.offer(GraphConversions.createGraphBinaryGraphNode(list2, this.graphBinaryModule));
                    continue;
                }
                graphNodes.offer(GraphSONUtils.createGraphNode(list2, this.subProtocol));
            }
            DefaultAsyncGraphResultSet resultSet = new DefaultAsyncGraphResultSet(executionInfo, graphNodes, this.subProtocol);
            if (this.result.complete(resultSet)) {
                this.cancelScheduledTasks();
                this.throttler.signalSuccess(this);
                long l = -1L;
                long totalLatencyNanos = -1L;
                if (!(this.requestTracker instanceof NoopRequestTracker)) {
                    l = System.nanoTime();
                    totalLatencyNanos = l - this.startTimeNanos;
                    long nodeLatencyNanos = l - callback.nodeStartTimeNanos;
                    this.requestTracker.onNodeSuccess(this.statement, nodeLatencyNanos, this.executionProfile, callback.node, this.logPrefix);
                    this.requestTracker.onSuccess(this.statement, totalLatencyNanos, this.executionProfile, callback.node, this.logPrefix);
                }
                if (this.sessionMetricUpdater.isEnabled(DseSessionMetric.GRAPH_REQUESTS, this.executionProfile.getName())) {
                    if (l == -1L) {
                        l = System.nanoTime();
                        totalLatencyNanos = l - this.startTimeNanos;
                    }
                    this.sessionMetricUpdater.updateTimer(DseSessionMetric.GRAPH_REQUESTS, this.executionProfile.getName(), totalLatencyNanos, TimeUnit.NANOSECONDS);
                }
            }
            if (!executionInfo.getWarnings().isEmpty() && this.executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOG_WARNINGS) && LOG.isWarnEnabled()) {
                this.logServerWarnings(executionInfo.getWarnings());
            }
        }
        catch (Throwable error2) {
            this.setFinalError(error2, callback.node, -1);
        }
    }

    private void logServerWarnings(List<String> warnings) {
        StringBuilder statementString = new StringBuilder();
        this.context.getRequestLogFormatter().appendRequest(this.statement, this.executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, 500), this.executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_VALUES, true), this.executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, 50), this.executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, 50), statementString);
        warnings.forEach(warning2 -> LOG.warn("Query '{}' generated server side warning(s): {}", (Object)statementString, warning2));
    }

    private ExecutionInfo buildExecutionInfo(NodeResponseCallback callback, Frame responseFrame) {
        return new DefaultExecutionInfo(this.statement, callback.node, this.startedSpeculativeExecutionsCount.get(), callback.execution, this.errors, null, responseFrame, true, this.session, this.context, this.executionProfile);
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error2) {
        this.sessionMetricUpdater.incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, this.executionProfile.getName());
        this.setFinalError(error2, null, -1);
    }

    private void setFinalError(Throwable error2, Node node, int execution) {
        if (error2 instanceof DriverException) {
            ((DriverException)error2).setExecutionInfo(new DefaultExecutionInfo(this.statement, node, this.startedSpeculativeExecutionsCount.get(), execution, this.errors, null, null, true, this.session, this.context, this.executionProfile));
        }
        if (this.result.completeExceptionally(error2)) {
            this.cancelScheduledTasks();
            if (!(this.requestTracker instanceof NoopRequestTracker)) {
                long latencyNanos = System.nanoTime() - this.startTimeNanos;
                this.requestTracker.onError(this.statement, error2, latencyNanos, this.executionProfile, node, this.logPrefix);
            }
            if (error2 instanceof DriverTimeoutException) {
                this.throttler.signalTimeout(this);
                this.sessionMetricUpdater.incrementCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, this.executionProfile.getName());
            } else if (!(error2 instanceof RequestThrottlingException)) {
                this.throttler.signalError(this, error2);
            }
        }
    }

    private class NodeResponseCallback
    implements ResponseCallback,
    GenericFutureListener<Future<Void>> {
        private final long nodeStartTimeNanos = System.nanoTime();
        private final Node node;
        private final Queue<Node> queryPlan;
        private final DriverChannel channel;
        private final int execution;
        private final int retryCount;
        private final boolean scheduleNextExecution;
        private final String logPrefix;

        private NodeResponseCallback(Node node, Queue<Node> queryPlan, DriverChannel channel, int execution, int retryCount, boolean scheduleNextExecution, String logPrefix) {
            this.node = node;
            this.queryPlan = queryPlan;
            this.channel = channel;
            this.execution = execution;
            this.retryCount = retryCount;
            this.scheduleNextExecution = scheduleNextExecution;
            this.logPrefix = logPrefix + "|" + execution;
        }

        @Override
        public void operationComplete(Future<Void> future) {
            if (!future.isSuccess()) {
                Throwable error2 = future.cause();
                if (error2 instanceof EncoderException && error2.getCause() instanceof FrameTooLongException) {
                    this.trackNodeError(this.node, error2.getCause(), -1L);
                    GraphRequestHandler.this.setFinalError(error2.getCause(), this.node, this.execution);
                } else {
                    LOG.trace("[{}] Failed to send request on {}, trying next node (cause: {})", this.logPrefix, this.channel, error2);
                    GraphRequestHandler.this.recordError(this.node, error2);
                    this.trackNodeError(this.node, error2, -1L);
                    ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.UNSENT_REQUESTS, GraphRequestHandler.this.executionProfile.getName());
                    GraphRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount, this.scheduleNextExecution);
                }
            } else {
                LOG.trace("[{}] Request sent on {}", (Object)this.logPrefix, (Object)this.channel);
                if (GraphRequestHandler.this.result.isDone()) {
                    this.cancel();
                } else {
                    GraphRequestHandler.this.inFlightCallbacks.add(this);
                    if (this.scheduleNextExecution && GraphRequestHandler.this.isIdempotent) {
                        long nextDelay;
                        int nextExecution = this.execution + 1;
                        try {
                            nextDelay = GraphRequestHandler.this.speculativeExecutionPolicy.nextExecution(this.node, null, GraphRequestHandler.this.statement, nextExecution);
                        }
                        catch (Throwable cause) {
                            LOG.error("[{}] Unexpected error while invoking the speculative execution policy", (Object)this.logPrefix, (Object)cause);
                            return;
                        }
                        if (nextDelay >= 0L) {
                            this.scheduleSpeculativeExecution(nextExecution, nextDelay);
                        } else {
                            LOG.trace("[{}] Speculative execution policy returned {}, no next execution", (Object)this.logPrefix, (Object)nextDelay);
                        }
                    }
                }
            }
        }

        private void scheduleSpeculativeExecution(int index2, long delay) {
            block2: {
                LOG.trace("[{}] Scheduling speculative execution {} in {} ms", this.logPrefix, index2, delay);
                try {
                    GraphRequestHandler.this.scheduledExecutions.add(GraphRequestHandler.this.timer.newTimeout(timeout1 -> {
                        if (!GraphRequestHandler.this.result.isDone()) {
                            LOG.trace("[{}] Starting speculative execution {}", (Object)GraphRequestHandler.this.logPrefix, (Object)index2);
                            GraphRequestHandler.this.activeExecutionsCount.incrementAndGet();
                            GraphRequestHandler.this.startedSpeculativeExecutionsCount.incrementAndGet();
                            ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, GraphRequestHandler.this.executionProfile.getName());
                            GraphRequestHandler.this.sendRequest(null, this.queryPlan, index2, 0, true);
                        }
                    }, delay, TimeUnit.MILLISECONDS));
                }
                catch (IllegalStateException e) {
                    if ("cannot be started once stopped".equals(e.getMessage())) break block2;
                    Loggers.warnWithException(LOG, "[{}] Error while scheduling speculative execution", this.logPrefix, e);
                }
            }
        }

        @Override
        public void onResponse(Frame responseFrame) {
            long nodeResponseTimeNanos = -1L;
            NodeMetricUpdater nodeMetricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (nodeMetricUpdater.isEnabled(DseNodeMetric.GRAPH_MESSAGES, GraphRequestHandler.this.executionProfile.getName())) {
                nodeResponseTimeNanos = System.nanoTime();
                long nodeLatency = System.nanoTime() - this.nodeStartTimeNanos;
                nodeMetricUpdater.updateTimer(DseNodeMetric.GRAPH_MESSAGES, GraphRequestHandler.this.executionProfile.getName(), nodeLatency, TimeUnit.NANOSECONDS);
            }
            GraphRequestHandler.this.inFlightCallbacks.remove(this);
            if (GraphRequestHandler.this.result.isDone()) {
                return;
            }
            try {
                Message responseMessage = responseFrame.message;
                if (responseMessage instanceof Result) {
                    LOG.trace("[{}] Got result, completing", (Object)this.logPrefix);
                    GraphRequestHandler.this.setFinalResult((Result)responseMessage, responseFrame, this);
                } else if (responseMessage instanceof Error) {
                    LOG.trace("[{}] Got error response, processing", (Object)this.logPrefix);
                    this.processErrorResponse((Error)responseMessage);
                } else {
                    this.trackNodeError(this.node, new IllegalStateException("Unexpected response " + responseMessage), nodeResponseTimeNanos);
                    GraphRequestHandler.this.setFinalError(new IllegalStateException("Unexpected response " + responseMessage), this.node, this.execution);
                }
            }
            catch (Throwable t) {
                this.trackNodeError(this.node, t, nodeResponseTimeNanos);
                GraphRequestHandler.this.setFinalError(t, this.node, this.execution);
            }
        }

        private void processErrorResponse(Error errorMessage2) {
            CoordinatorException error2 = Conversions.toThrowable(this.node, errorMessage2, GraphRequestHandler.this.context);
            NodeMetricUpdater metricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (error2 instanceof BootstrappingException) {
                LOG.trace("[{}] {} is bootstrapping, trying next node", (Object)this.logPrefix, (Object)this.node);
                GraphRequestHandler.this.recordError(this.node, error2);
                this.trackNodeError(this.node, error2, -1L);
                GraphRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount, false);
            } else if (error2 instanceof QueryValidationException || error2 instanceof FunctionFailureException || error2 instanceof ProtocolError) {
                LOG.trace("[{}] Unrecoverable error, rethrowing", (Object)this.logPrefix);
                metricUpdater.incrementCounter(DefaultNodeMetric.OTHER_ERRORS, GraphRequestHandler.this.executionProfile.getName());
                this.trackNodeError(this.node, error2, -1L);
                GraphRequestHandler.this.setFinalError(error2, this.node, this.execution);
            } else {
                RetryDecision decision;
                if (error2 instanceof ReadTimeoutException) {
                    ReadTimeoutException readTimeout = (ReadTimeoutException)error2;
                    decision = GraphRequestHandler.this.retryPolicy.onReadTimeout(GraphRequestHandler.this.statement, readTimeout.getConsistencyLevel(), readTimeout.getBlockFor(), readTimeout.getReceived(), readTimeout.wasDataPresent(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT);
                } else if (error2 instanceof WriteTimeoutException) {
                    WriteTimeoutException writeTimeout = (WriteTimeoutException)error2;
                    decision = GraphRequestHandler.this.isIdempotent ? GraphRequestHandler.this.retryPolicy.onWriteTimeout(GraphRequestHandler.this.statement, writeTimeout.getConsistencyLevel(), writeTimeout.getWriteType(), writeTimeout.getBlockFor(), writeTimeout.getReceived(), this.retryCount) : RetryDecision.RETHROW;
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT);
                } else if (error2 instanceof UnavailableException) {
                    UnavailableException unavailable = (UnavailableException)error2;
                    decision = GraphRequestHandler.this.retryPolicy.onUnavailable(GraphRequestHandler.this.statement, unavailable.getConsistencyLevel(), unavailable.getRequired(), unavailable.getAlive(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE);
                } else {
                    decision = GraphRequestHandler.this.isIdempotent ? GraphRequestHandler.this.retryPolicy.onErrorResponse(GraphRequestHandler.this.statement, error2, this.retryCount) : RetryDecision.RETHROW;
                    this.updateErrorMetrics(metricUpdater, decision, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR);
                }
                this.processRetryDecision(decision, error2);
            }
        }

        private void processRetryDecision(RetryDecision decision, Throwable error2) {
            LOG.trace("[{}] Processing retry decision {}", (Object)this.logPrefix, (Object)decision);
            switch (decision) {
                case RETRY_SAME: {
                    GraphRequestHandler.this.recordError(this.node, error2);
                    this.trackNodeError(this.node, error2, -1L);
                    GraphRequestHandler.this.sendRequest(this.node, this.queryPlan, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETRY_NEXT: {
                    GraphRequestHandler.this.recordError(this.node, error2);
                    this.trackNodeError(this.node, error2, -1L);
                    GraphRequestHandler.this.sendRequest(null, this.queryPlan, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETHROW: {
                    this.trackNodeError(this.node, error2, -1L);
                    GraphRequestHandler.this.setFinalError(error2, this.node, this.execution);
                    break;
                }
                case IGNORE: {
                    GraphRequestHandler.this.setFinalResult(com.datastax.oss.protocol.internal.response.result.Void.INSTANCE, null, this);
                }
            }
        }

        private void updateErrorMetrics(NodeMetricUpdater metricUpdater, RetryDecision decision, DefaultNodeMetric error2, DefaultNodeMetric retriesOnError, DefaultNodeMetric ignoresOnError) {
            metricUpdater.incrementCounter(error2, GraphRequestHandler.this.executionProfile.getName());
            switch (decision) {
                case RETRY_SAME: 
                case RETRY_NEXT: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.RETRIES, GraphRequestHandler.this.executionProfile.getName());
                    metricUpdater.incrementCounter(retriesOnError, GraphRequestHandler.this.executionProfile.getName());
                    break;
                }
                case IGNORE: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.IGNORES, GraphRequestHandler.this.executionProfile.getName());
                    metricUpdater.incrementCounter(ignoresOnError, GraphRequestHandler.this.executionProfile.getName());
                    break;
                }
            }
        }

        @Override
        public void onFailure(Throwable error2) {
            RetryDecision decision;
            GraphRequestHandler.this.inFlightCallbacks.remove(this);
            if (GraphRequestHandler.this.result.isDone()) {
                return;
            }
            LOG.trace("[{}] Request failure, processing: {}", (Object)this.logPrefix, (Object)error2);
            if (!GraphRequestHandler.this.isIdempotent || error2 instanceof FrameTooLongException) {
                decision = RetryDecision.RETHROW;
            } else {
                try {
                    decision = GraphRequestHandler.this.retryPolicy.onRequestAborted(GraphRequestHandler.this.statement, error2, this.retryCount);
                }
                catch (Throwable cause) {
                    GraphRequestHandler.this.setFinalError(new IllegalStateException("Unexpected error while invoking the retry policy", cause), this.node, -1);
                    return;
                }
            }
            this.processRetryDecision(decision, error2);
            this.updateErrorMetrics(((DefaultNode)this.node).getMetricUpdater(), decision, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED);
        }

        void cancel() {
            try {
                if (!this.channel.closeFuture().isDone()) {
                    this.channel.cancel(this);
                }
            }
            catch (Throwable t) {
                Loggers.warnWithException(LOG, "[{}] Error cancelling", this.logPrefix, t);
            }
        }

        private void trackNodeError(Node node, Throwable error2, long nodeResponseTimeNanos) {
            if (GraphRequestHandler.this.requestTracker instanceof NoopRequestTracker) {
                return;
            }
            if (nodeResponseTimeNanos == -1L) {
                nodeResponseTimeNanos = System.nanoTime();
            }
            long latencyNanos = nodeResponseTimeNanos - this.nodeStartTimeNanos;
            GraphRequestHandler.this.requestTracker.onNodeError(GraphRequestHandler.this.statement, error2, latencyNanos, GraphRequestHandler.this.executionProfile, node, this.logPrefix);
        }

        public String toString() {
            return this.logPrefix;
        }
    }
}

