/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.FluentGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.internal.core.graph.BytecodeGraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.ObjectGraphNode;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.dse.protocol.internal.request.RawBytesQuery;
import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.BufferFactory;

public class GraphConversions
extends Conversions {
    static final String GRAPH_LANG_OPTION_KEY = "graph-language";
    static final String GRAPH_NAME_OPTION_KEY = "graph-name";
    static final String GRAPH_SOURCE_OPTION_KEY = "graph-source";
    static final String GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY = "graph-read-consistency";
    static final String GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY = "graph-write-consistency";
    static final String GRAPH_RESULTS_OPTION_KEY = "graph-results";
    static final String GRAPH_TIMEOUT_OPTION_KEY = "request-timeout";
    static final String GRAPH_BINARY_QUERY_OPTION_KEY = "graph-binary-query";
    static final String LANGUAGE_GROOVY = "gremlin-groovy";
    static final String LANGUAGE_BYTECODE = "bytecode-json";
    private static final BufferFactory<ByteBuf> FACTORY = new DseNettyBufferFactory();
    @VisibleForTesting
    static final byte[] EMPTY_STRING_QUERY = "".getBytes(StandardCharsets.UTF_8);

    public static Message createContinuousMessageFromGraphStatement(GraphStatement<?> statement2, GraphProtocol subProtocol, DriverExecutionProfile config, InternalDriverContext context, GraphBinaryModule graphBinaryModule) {
        List<ByteBuffer> encodedQueryParams;
        if (!(statement2 instanceof ScriptGraphStatement) || ((ScriptGraphStatement)statement2).getQueryParams().isEmpty()) {
            encodedQueryParams = Collections.emptyList();
        } else {
            try {
                Map<String, Object> queryParams = ((ScriptGraphStatement)statement2).getQueryParams();
                if (subProtocol.isGraphBinary()) {
                    Buffer graphBinaryParams = graphBinaryModule.serialize(queryParams);
                    encodedQueryParams = Collections.singletonList(graphBinaryParams.nioBuffer());
                    graphBinaryParams.release();
                } else {
                    encodedQueryParams = Collections.singletonList(GraphSONUtils.serializeToByteBuffer(queryParams, subProtocol));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't serialize parameters for GraphStatement: " + statement2, e);
            }
        }
        int consistencyLevel = DefaultConsistencyLevel.valueOf(config.getString(DefaultDriverOption.REQUEST_CONSISTENCY)).getProtocolCode();
        long timestamp2 = statement2.getTimestamp();
        if (timestamp2 == Long.MIN_VALUE) {
            timestamp2 = context.getTimestampGenerator().next();
        }
        int pageSize = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_PAGE_SIZE);
        int maxPages = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES);
        int maxPagesPerSecond = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND);
        int maxEnqueuedPages = config.getInt(DseDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES);
        ContinuousPagingOptions options = new ContinuousPagingOptions(maxPages, maxPagesPerSecond, maxEnqueuedPages);
        DseQueryOptions queryOptions = new DseQueryOptions(consistencyLevel, encodedQueryParams, Collections.emptyMap(), true, pageSize, null, 9, timestamp2, null, false, options);
        if (statement2 instanceof ScriptGraphStatement) {
            return new Query(((ScriptGraphStatement)statement2).getScript(), queryOptions);
        }
        return new RawBytesQuery(GraphConversions.getQueryBytes(statement2, subProtocol), queryOptions);
    }

    static Message createMessageFromGraphStatement(GraphStatement<?> statement2, GraphProtocol subProtocol, DriverExecutionProfile config, InternalDriverContext context, GraphBinaryModule graphBinaryModule) {
        List<Object> encodedQueryParams;
        if (!(statement2 instanceof ScriptGraphStatement) || ((ScriptGraphStatement)statement2).getQueryParams().isEmpty()) {
            encodedQueryParams = Collections.emptyList();
        } else {
            try {
                Map<String, Object> queryParams = ((ScriptGraphStatement)statement2).getQueryParams();
                if (subProtocol.isGraphBinary()) {
                    Buffer graphBinaryParams = graphBinaryModule.serialize(queryParams);
                    encodedQueryParams = Collections.singletonList(graphBinaryParams.nioBuffer());
                    graphBinaryParams.release();
                } else {
                    encodedQueryParams = Collections.singletonList(GraphSONUtils.serializeToByteBuffer(queryParams, subProtocol));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't serialize parameters for GraphStatement: " + statement2, e);
            }
        }
        int consistencyLevel = DefaultConsistencyLevel.valueOf(config.getString(DefaultDriverOption.REQUEST_CONSISTENCY)).getProtocolCode();
        long timestamp2 = statement2.getTimestamp();
        if (timestamp2 == Long.MIN_VALUE) {
            timestamp2 = context.getTimestampGenerator().next();
        }
        DseQueryOptions queryOptions = new DseQueryOptions(consistencyLevel, encodedQueryParams, Collections.emptyMap(), true, 50, null, 9, timestamp2, null, false, null);
        if (statement2 instanceof ScriptGraphStatement) {
            return new Query(((ScriptGraphStatement)statement2).getScript(), queryOptions);
        }
        return new RawBytesQuery(GraphConversions.getQueryBytes(statement2, subProtocol), queryOptions);
    }

    @VisibleForTesting
    public static Object bytecodeToSerialize(GraphStatement<?> statement2) {
        Preconditions.checkArgument(statement2 instanceof FluentGraphStatement || statement2 instanceof BatchGraphStatement || statement2 instanceof BytecodeGraphStatement, "To serialize bytecode the query must be a fluent or batch statement, but was: %s", statement2.getClass());
        Serializable toSerialize = statement2 instanceof FluentGraphStatement ? ((FluentGraphStatement)statement2).getTraversal().asAdmin().getBytecode() : (statement2 instanceof BatchGraphStatement ? ImmutableList.copyOf(Iterators.transform(((BatchGraphStatement)statement2).iterator(), traversal -> traversal.asAdmin().getBytecode())) : ((BytecodeGraphStatement)statement2).getBytecode());
        return toSerialize;
    }

    private static byte[] getQueryBytes(GraphStatement<?> statement2, GraphProtocol graphSubProtocol) {
        try {
            return graphSubProtocol.isGraphBinary() ? EMPTY_STRING_QUERY : GraphSONUtils.serializeToBytes(GraphConversions.bytecodeToSerialize(statement2), graphSubProtocol);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Map<String, ByteBuffer> createCustomPayload(GraphStatement<?> statement2, GraphProtocol subProtocol, DriverExecutionProfile config, InternalDriverContext context, GraphBinaryModule graphBinaryModule) {
        ByteBuffer payloadInitialProtocol;
        String graphLanguage;
        ProtocolVersion protocolVersion = context.getProtocolVersion();
        NullAllowingImmutableMap.Builder<String, ByteBuffer> payload = NullAllowingImmutableMap.builder();
        Map<String, ByteBuffer> statementOptions = statement2.getCustomPayload();
        payload.putAll(statementOptions);
        if (!statementOptions.containsKey(GRAPH_LANG_OPTION_KEY)) {
            graphLanguage = statement2 instanceof ScriptGraphStatement ? LANGUAGE_GROOVY : LANGUAGE_BYTECODE;
            payload.put(GRAPH_LANG_OPTION_KEY, TypeCodecs.TEXT.encode(graphLanguage, protocolVersion));
        } else {
            graphLanguage = TypeCodecs.TEXT.decode(statementOptions.get(GRAPH_LANG_OPTION_KEY), protocolVersion);
            Preconditions.checkNotNull(graphLanguage, "A null value was set for the graph-language custom payload key.");
        }
        if (!GraphConversions.isSystemQuery(statement2, config)) {
            if (!statementOptions.containsKey(GRAPH_NAME_OPTION_KEY)) {
                String graphName = statement2.getGraphName();
                if (graphName == null) {
                    graphName = config.getString(DseDriverOption.GRAPH_NAME, null);
                }
                if (graphName != null) {
                    payload.put(GRAPH_NAME_OPTION_KEY, TypeCodecs.TEXT.encode(graphName, protocolVersion));
                }
            }
            if (!statementOptions.containsKey(GRAPH_SOURCE_OPTION_KEY)) {
                String traversalSource = statement2.getTraversalSource();
                if (traversalSource == null) {
                    traversalSource = config.getString(DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null);
                }
                if (traversalSource != null) {
                    payload.put(GRAPH_SOURCE_OPTION_KEY, TypeCodecs.TEXT.encode(traversalSource, protocolVersion));
                }
            }
        }
        if ((payloadInitialProtocol = statementOptions.get(GRAPH_RESULTS_OPTION_KEY)) == null) {
            Preconditions.checkNotNull(subProtocol);
            payload.put(GRAPH_RESULTS_OPTION_KEY, TypeCodecs.TEXT.encode(subProtocol.toInternalCode(), protocolVersion));
        } else {
            subProtocol = GraphProtocol.fromString(TypeCodecs.TEXT.decode(payloadInitialProtocol, protocolVersion));
        }
        if (subProtocol.isGraphBinary() && graphLanguage.equals(LANGUAGE_BYTECODE)) {
            Object bytecodeQuery = GraphConversions.bytecodeToSerialize(statement2);
            try {
                Buffer bytecodeByteBuf = graphBinaryModule.serialize(bytecodeQuery);
                payload.put(GRAPH_BINARY_QUERY_OPTION_KEY, bytecodeByteBuf.nioBuffer());
                bytecodeByteBuf.release();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (!statementOptions.containsKey(GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY)) {
            String readClString;
            ConsistencyLevel readCl = statement2.getReadConsistencyLevel();
            String string2 = readClString = readCl != null ? readCl.name() : config.getString(DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null);
            if (readClString != null) {
                payload.put(GRAPH_READ_CONSISTENCY_LEVEL_OPTION_KEY, TypeCodecs.TEXT.encode(readClString, protocolVersion));
            }
        }
        if (!statementOptions.containsKey(GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY)) {
            String writeClString;
            ConsistencyLevel writeCl = statement2.getWriteConsistencyLevel();
            String string3 = writeClString = writeCl != null ? writeCl.name() : config.getString(DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null);
            if (writeClString != null) {
                payload.put(GRAPH_WRITE_CONSISTENCY_LEVEL_OPTION_KEY, TypeCodecs.TEXT.encode(writeClString, protocolVersion));
            }
        }
        if (!statementOptions.containsKey(GRAPH_TIMEOUT_OPTION_KEY)) {
            Duration timeout = statement2.getTimeout();
            if (timeout == null) {
                timeout = config.getDuration(DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO);
            }
            if (timeout != null && !timeout.isZero()) {
                payload.put(GRAPH_TIMEOUT_OPTION_KEY, TypeCodecs.BIGINT.encode(timeout.toMillis(), protocolVersion));
            }
        }
        return payload.build();
    }

    private static boolean isSystemQuery(GraphStatement<?> statement2, DriverExecutionProfile config) {
        Boolean statementValue;
        if (statement2 instanceof ScriptGraphStatement && (statementValue = ((ScriptGraphStatement)statement2).isSystemQuery()) != null) {
            return statementValue;
        }
        return config.getBoolean(DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false);
    }

    public static GraphNode createGraphBinaryGraphNode(List<ByteBuffer> data2, GraphBinaryModule graphBinaryModule) throws IOException {
        Preconditions.checkArgument(data2.size() == 1, "Invalid row given to deserialize");
        Buffer toDeserialize = FACTORY.wrap(data2.get(0));
        Object deserializedObject = graphBinaryModule.deserialize(toDeserialize);
        toDeserialize.release();
        assert (deserializedObject instanceof Traverser) : "Graph protocol error. Received object should be a Traverser but it is not.";
        return new ObjectGraphNode(deserializedObject);
    }
}

