/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.internal.core.graph.GraphStatementBase;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultScriptGraphStatement
extends GraphStatementBase<ScriptGraphStatement>
implements ScriptGraphStatement {
    private final String script;
    private final Boolean isSystemQuery;
    private final NullAllowingImmutableMap<String, Object> queryParams;

    public DefaultScriptGraphStatement(String script, Map<String, Object> queryParams, Boolean isSystemQuery, Boolean isIdempotent, Duration timeout, Node node, long timestamp2, DriverExecutionProfile executionProfile, String executionProfileName, Map<String, ByteBuffer> customPayload, String graphName, String traversalSource, String subProtocol, ConsistencyLevel consistencyLevel, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        super(isIdempotent, timeout, node, timestamp2, executionProfile, executionProfileName, customPayload, graphName, traversalSource, subProtocol, consistencyLevel, readConsistencyLevel, writeConsistencyLevel);
        this.script = script;
        this.isSystemQuery = isSystemQuery;
        this.queryParams = NullAllowingImmutableMap.copyOf(queryParams);
    }

    @Override
    @NonNull
    public String getScript() {
        return this.script;
    }

    @Override
    @NonNull
    public ScriptGraphStatement setSystemQuery(@Nullable Boolean newValue) {
        return new DefaultScriptGraphStatement(this.script, this.queryParams, newValue, this.isIdempotent(), this.getTimeout(), this.getNode(), this.getTimestamp(), this.getExecutionProfile(), this.getExecutionProfileName(), this.getCustomPayload(), this.getGraphName(), this.getTraversalSource(), this.getSubProtocol(), this.getConsistencyLevel(), this.getReadConsistencyLevel(), this.getWriteConsistencyLevel());
    }

    @Override
    @Nullable
    public Boolean isSystemQuery() {
        return this.isSystemQuery;
    }

    @Override
    @NonNull
    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    @Override
    @NonNull
    public ScriptGraphStatement setQueryParam(@NonNull String name2, @Nullable Object value2) {
        NullAllowingImmutableMap.Builder<String, Object> newQueryParamsBuilder = NullAllowingImmutableMap.builder();
        for (Map.Entry<String, Object> entry2 : this.queryParams.entrySet()) {
            if (entry2.getKey().equals(name2)) continue;
            newQueryParamsBuilder.put(entry2.getKey(), entry2.getValue());
        }
        newQueryParamsBuilder.put(name2, value2);
        return this.setQueryParams(newQueryParamsBuilder.build());
    }

    @Override
    @NonNull
    public ScriptGraphStatement removeQueryParam(@NonNull String name2) {
        if (!this.queryParams.containsKey(name2)) {
            return this;
        }
        NullAllowingImmutableMap.Builder<String, Object> newQueryParamsBuilder = NullAllowingImmutableMap.builder();
        for (Map.Entry<String, Object> entry2 : this.queryParams.entrySet()) {
            if (entry2.getKey().equals(name2)) continue;
            newQueryParamsBuilder.put(entry2.getKey(), entry2.getValue());
        }
        return this.setQueryParams(newQueryParamsBuilder.build());
    }

    private ScriptGraphStatement setQueryParams(Map<String, Object> newQueryParams) {
        return new DefaultScriptGraphStatement(this.script, newQueryParams, this.isSystemQuery, this.isIdempotent(), this.getTimeout(), this.getNode(), this.getTimestamp(), this.getExecutionProfile(), this.getExecutionProfileName(), this.getCustomPayload(), this.getGraphName(), this.getTraversalSource(), this.getSubProtocol(), this.getConsistencyLevel(), this.getReadConsistencyLevel(), this.getWriteConsistencyLevel());
    }

    @Override
    protected ScriptGraphStatement newInstance(Boolean isIdempotent, Duration timeout, Node node, long timestamp2, DriverExecutionProfile executionProfile, String executionProfileName, Map<String, ByteBuffer> customPayload, String graphName, String traversalSource, String subProtocol, ConsistencyLevel consistencyLevel, ConsistencyLevel readConsistencyLevel, ConsistencyLevel writeConsistencyLevel) {
        return new DefaultScriptGraphStatement(this.script, this.queryParams, this.isSystemQuery, isIdempotent, timeout, node, timestamp2, executionProfile, executionProfileName, customPayload, graphName, traversalSource, subProtocol, consistencyLevel, readConsistencyLevel, writeConsistencyLevel);
    }

    public String toString() {
        return String.format("ScriptGraphStatement['%s', params: %s]", this.script, this.queryParams);
    }
}

