/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.internal.core.graph.DsePredicate;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.javatuples.Pair;

public enum CqlCollectionPredicate implements DsePredicate
{
    contains{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument(value2 instanceof Collection);
            return ((Collection)value2).contains(condition);
        }
    }
    ,
    containsKey{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument(value2 instanceof Map);
            return ((Map)value2).containsKey(condition);
        }
    }
    ,
    containsValue{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument(value2 instanceof Map);
            return ((Map)value2).containsValue(condition);
        }
    }
    ,
    entryEq{

        @Override
        public boolean test(Object value2, Object condition) {
            this.preEvaluate(condition);
            Preconditions.checkArgument(condition instanceof Pair);
            Preconditions.checkArgument(value2 instanceof Map);
            Pair pair2 = (Pair)condition;
            Map map2 = (Map)value2;
            return Objects.equals(map2.get(pair2.getValue0()), pair2.getValue1());
        }
    };


    @Override
    public boolean isValidCondition(Object condition) {
        if (condition instanceof Pair) {
            Pair pair2 = (Pair)condition;
            return pair2.getValue0() != null && pair2.getValue1() != null;
        }
        return condition != null;
    }
}

