/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;

public class ByteBufUtil {
    public static ByteBuffer toByteBuffer(ByteBuf buffer) {
        if (buffer.isDirect()) {
            return buffer.nioBuffer();
        }
        byte[] bytes2 = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), bytes2);
        return ByteBuffer.wrap(bytes2);
    }

    static ByteBuf toByteBuf(ByteBuffer buffer) {
        return Unpooled.wrappedBuffer(buffer);
    }

    public static ByteBuffer readBytes(ByteBuf nettyBuf, int size2) {
        ByteBuffer res = ByteBuffer.allocate(size2);
        nettyBuf.readBytes(res);
        res.flip();
        return res;
    }
}

