/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorExportToWkb;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class WkbUtil {
    private static final boolean IS_NATIVE_LITTLE_ENDIAN;
    private static final Method exportToWKB;

    WkbUtil() {
    }

    static ByteBuffer asLittleEndianBinary(OGCGeometry ogcGeometry) {
        int exportFlags;
        if (IS_NATIVE_LITTLE_ENDIAN) {
            return ogcGeometry.asBinary();
        }
        if (ogcGeometry instanceof OGCPoint) {
            exportFlags = 0;
        } else if (ogcGeometry instanceof OGCLineString) {
            exportFlags = 4;
        } else if (ogcGeometry instanceof OGCPolygon) {
            exportFlags = 16;
        } else {
            throw new AssertionError((Object)("Unsupported type: " + ogcGeometry.getClass()));
        }
        int size2 = WkbUtil.exportToWKB(exportFlags, ogcGeometry.getEsriGeometry(), null);
        ByteBuffer wkbBuffer = ByteBuffer.allocate(size2).order(ByteOrder.LITTLE_ENDIAN);
        WkbUtil.exportToWKB(exportFlags, ogcGeometry.getEsriGeometry(), wkbBuffer);
        return wkbBuffer;
    }

    private static int exportToWKB(int exportFlags, Geometry geometry, ByteBuffer wkbBuffer) {
        assert (!IS_NATIVE_LITTLE_ENDIAN);
        try {
            return (Integer)exportToWKB.invoke(null, exportFlags, geometry, wkbBuffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't invoke private method OperatorExportToWkbLocal#exportToWKB", e);
        }
    }

    static {
        boolean bl = IS_NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) && System.getProperty("com.datastax.driver.dse.geometry.FORCE_REFLECTION_WKB") == null;
        if (IS_NATIVE_LITTLE_ENDIAN) {
            exportToWKB = null;
        } else {
            try {
                OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
                exportToWKB = op.getClass().getDeclaredMethod("exportToWKB", Integer.TYPE, Geometry.class, ByteBuffer.class);
                exportToWKB.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Couldn't get access to private method OperatorExportToWkbLocal#exportToWKB", e);
            }
        }
    }
}

