/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.WkbSerializationProxy;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorSimplifyOGC;
import com.esri.core.geometry.ogc.OGCPolygon;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultPolygon
extends DefaultGeometry
implements Polygon {
    private static final long serialVersionUID = 3694196802962890314L;
    private final List<Point> exteriorRing;
    private final List<List<Point>> interiorRings;

    public DefaultPolygon(@NonNull Point p1, @NonNull Point p2, @NonNull Point p3, Point ... pn) {
        super(DefaultPolygon.fromPoints(p1, p2, p3, pn));
        this.exteriorRing = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(p1)).add(p2)).add(p3)).add(pn)).build();
        this.interiorRings = Collections.emptyList();
    }

    public DefaultPolygon(@NonNull OGCPolygon polygon) {
        super(polygon);
        this.exteriorRing = polygon.isEmpty() ? ImmutableList.of() : DefaultPolygon.getPoints(polygon.exteriorRing());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < polygon.numInteriorRing(); ++i) {
            builder.add(DefaultPolygon.getPoints(polygon.interiorRingN(i)));
        }
        this.interiorRings = builder.build();
    }

    @Override
    @NonNull
    public List<Point> getExteriorRing() {
        return this.exteriorRing;
    }

    @Override
    @NonNull
    public List<List<Point>> getInteriorRings() {
        return this.interiorRings;
    }

    private static OGCPolygon fromPoints(Point p1, Point p2, Point p3, Point ... pn) {
        com.esri.core.geometry.Polygon polygon = new com.esri.core.geometry.Polygon();
        DefaultPolygon.addPath(polygon, p1, p2, p3, pn);
        return new OGCPolygon(DefaultPolygon.simplify(polygon), DefaultGeometry.SPATIAL_REFERENCE_4326);
    }

    private static void addPath(com.esri.core.geometry.Polygon polygon, Point p1, Point p2, Point p3, Point[] pn) {
        polygon.startPath(DefaultPolygon.toEsri(p1));
        polygon.lineTo(DefaultPolygon.toEsri(p2));
        polygon.lineTo(DefaultPolygon.toEsri(p3));
        for (Point p : pn) {
            polygon.lineTo(DefaultPolygon.toEsri(p));
        }
    }

    private static com.esri.core.geometry.Polygon simplify(com.esri.core.geometry.Polygon polygon) {
        OperatorSimplifyOGC op = (OperatorSimplifyOGC)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.SimplifyOGC);
        return (com.esri.core.geometry.Polygon)op.execute(polygon, DefaultGeometry.SPATIAL_REFERENCE_4326, true, null);
    }

    private Object writeReplace() {
        return new WkbSerializationProxy(this.asWellKnownBinary());
    }

    public static class Builder
    implements Polygon.Builder {
        private final com.esri.core.geometry.Polygon polygon = new com.esri.core.geometry.Polygon();

        @Override
        @NonNull
        public Builder addRing(@NonNull Point p1, @NonNull Point p2, @NonNull Point p3, Point ... pn) {
            DefaultPolygon.addPath(this.polygon, p1, p2, p3, pn);
            return this;
        }

        @Override
        @NonNull
        public Polygon build() {
            return new DefaultPolygon(new OGCPolygon(DefaultPolygon.simplify(this.polygon), DefaultGeometry.SPATIAL_REFERENCE_4326));
        }
    }
}

