/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousCqlRequestHandler;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.cql.EmptyColumnDefinitions;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultContinuousAsyncResultSet
implements ContinuousAsyncResultSet {
    private final Iterable<Row> currentPage;
    private final ColumnDefinitions columnDefinitions;
    private final int pageNumber;
    private final boolean hasMorePages;
    private final ExecutionInfo executionInfo;
    private final ContinuousCqlRequestHandler handler;
    private final CountingIterator<Row> iterator;

    public DefaultContinuousAsyncResultSet(CountingIterator<Row> iterator2, ColumnDefinitions columnDefinitions, int pageNumber, boolean hasMorePages, ExecutionInfo executionInfo, ContinuousCqlRequestHandler handler) {
        this.columnDefinitions = columnDefinitions;
        this.pageNumber = pageNumber;
        this.hasMorePages = hasMorePages;
        this.executionInfo = executionInfo;
        this.handler = handler;
        this.iterator = iterator2;
        this.currentPage = () -> iterator2;
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    public boolean wasApplied() {
        return true;
    }

    @Override
    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    public int pageNumber() {
        return this.pageNumber;
    }

    @Override
    public boolean hasMorePages() {
        return this.hasMorePages;
    }

    @Override
    @NonNull
    public Iterable<Row> currentPage() {
        return this.currentPage;
    }

    @Override
    public int remaining() {
        return this.iterator.remaining();
    }

    @Override
    @NonNull
    public CompletionStage<ContinuousAsyncResultSet> fetchNextPage() throws IllegalStateException {
        if (!this.hasMorePages()) {
            throw new IllegalStateException("Can't call fetchNextPage() on the last page (use hasMorePages() to check)");
        }
        return this.handler.fetchNextPage();
    }

    @Override
    public void cancel() {
        this.handler.cancel();
    }

    public static ContinuousAsyncResultSet empty(final ExecutionInfo executionInfo) {
        return new ContinuousAsyncResultSet(){

            @Override
            @NonNull
            public ColumnDefinitions getColumnDefinitions() {
                return EmptyColumnDefinitions.INSTANCE;
            }

            @Override
            @NonNull
            public ExecutionInfo getExecutionInfo() {
                return executionInfo;
            }

            @Override
            @NonNull
            public Iterable<Row> currentPage() {
                return Collections.emptyList();
            }

            @Override
            public int remaining() {
                return 0;
            }

            @Override
            public boolean hasMorePages() {
                return false;
            }

            @Override
            public int pageNumber() {
                return 1;
            }

            @Override
            @NonNull
            public CompletionStage<ContinuousAsyncResultSet> fetchNextPage() throws IllegalStateException {
                throw new IllegalStateException("Can't call fetchNextPage() on the last page (use hasMorePages() to check)");
            }

            @Override
            public void cancel() {
            }

            @Override
            public boolean wasApplied() {
                return true;
            }
        };
    }
}

