/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.cql.continuous.ContinuousAsyncResultSet;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.cql.DseConversions;
import com.datastax.dse.driver.internal.core.cql.continuous.ContinuousRequestHandlerBase;
import com.datastax.dse.driver.internal.core.cql.continuous.DefaultContinuousAsyncResultSet;
import com.datastax.dse.protocol.internal.response.result.DseRowsMetadata;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.DefaultRow;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ContinuousCqlRequestHandler
extends ContinuousRequestHandlerBase<Statement, ContinuousAsyncResultSet> {
    private final Message message;
    private final Duration firstPageTimeout;
    private final Duration otherPagesTimeout;
    private final int maxEnqueuedPages;
    private final int maxPages;

    ContinuousCqlRequestHandler(@NonNull Statement<?> statement2, @NonNull DefaultSession session, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix) {
        super(statement2, session, context, sessionLogPrefix, ContinuousAsyncResultSet.class, false, DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, DseSessionMetric.CONTINUOUS_CQL_REQUESTS, DefaultNodeMetric.CQL_MESSAGES);
        this.message = DseConversions.toContinuousPagingMessage(statement2, this.executionProfile, context);
        this.firstPageTimeout = this.executionProfile.getDuration(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE);
        this.otherPagesTimeout = this.executionProfile.getDuration(DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES);
        this.maxEnqueuedPages = this.executionProfile.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES);
        this.maxPages = this.executionProfile.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES);
        this.throttler.register(this);
    }

    @Override
    @NonNull
    protected Duration getGlobalTimeout() {
        return Duration.ZERO;
    }

    @Override
    @NonNull
    protected Duration getPageTimeout(int pageNumber) {
        return pageNumber == 1 ? this.firstPageTimeout : this.otherPagesTimeout;
    }

    @Override
    @NonNull
    protected Duration getReviseRequestTimeout() {
        return this.otherPagesTimeout;
    }

    @Override
    protected int getMaxEnqueuedPages() {
        return this.maxEnqueuedPages;
    }

    @Override
    protected int getMaxPages() {
        return this.maxPages;
    }

    @Override
    @NonNull
    protected Message getMessage() {
        return this.message;
    }

    @Override
    protected boolean isTracingEnabled() {
        return false;
    }

    @Override
    @NonNull
    protected Map<String, ByteBuffer> createPayload() {
        return ((Statement)this.statement).getCustomPayload();
    }

    @Override
    @NonNull
    protected ContinuousAsyncResultSet createEmptyResultSet(@NonNull ExecutionInfo executionInfo) {
        return DefaultContinuousAsyncResultSet.empty(executionInfo);
    }

    @Override
    @NonNull
    protected DefaultContinuousAsyncResultSet createResultSet(@NonNull Rows rows, @NonNull ExecutionInfo executionInfo, final @NonNull ColumnDefinitions columnDefinitions) {
        final Queue<List<ByteBuffer>> data2 = rows.getData();
        CountingIterator<Row> iterator2 = new CountingIterator<Row>(data2.size()){

            @Override
            protected Row computeNext() {
                List rowData = (List)data2.poll();
                return rowData == null ? (Row)this.endOfData() : new DefaultRow(columnDefinitions, rowData, ContinuousCqlRequestHandler.this.context);
            }
        };
        DseRowsMetadata metadata = (DseRowsMetadata)rows.getMetadata();
        return new DefaultContinuousAsyncResultSet(iterator2, columnDefinitions, metadata.continuousPageNumber, !metadata.isLastContinuousPage, executionInfo, this);
    }

    @Override
    protected int pageNumber(@NonNull ContinuousAsyncResultSet resultSet) {
        return resultSet.pageNumber();
    }
}

