/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.servererrors.UnfitClientException;
import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.ConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Execute;
import com.datastax.oss.protocol.internal.request.Query;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DseConversions {
    public static Message toContinuousPagingMessage(Statement<?> statement2, DriverExecutionProfile config, InternalDriverContext context) {
        ConsistencyLevelRegistry consistencyLevelRegistry = context.getConsistencyLevelRegistry();
        ConsistencyLevel consistency2 = statement2.getConsistencyLevel();
        int consistencyCode = consistency2 == null ? consistencyLevelRegistry.nameToCode(config.getString(DefaultDriverOption.REQUEST_CONSISTENCY)) : consistency2.getProtocolCode();
        int pageSize = config.getInt(DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE);
        boolean pageSizeInBytes = config.getBoolean(DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE_BYTES);
        int maxPages = config.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES);
        int maxPagesPerSecond = config.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND);
        int maxEnqueuedPages = config.getInt(DseDriverOption.CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES);
        ContinuousPagingOptions options = new ContinuousPagingOptions(maxPages, maxPagesPerSecond, maxEnqueuedPages);
        ConsistencyLevel serialConsistency2 = statement2.getSerialConsistencyLevel();
        int serialConsistencyCode = serialConsistency2 == null ? consistencyLevelRegistry.nameToCode(config.getString(DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)) : serialConsistency2.getProtocolCode();
        long timestamp2 = statement2.getQueryTimestamp();
        if (timestamp2 == Long.MIN_VALUE) {
            timestamp2 = context.getTimestampGenerator().next();
        }
        CodecRegistry codecRegistry = context.getCodecRegistry();
        ProtocolVersion protocolVersion = context.getProtocolVersion();
        ProtocolVersionRegistry protocolVersionRegistry = context.getProtocolVersionRegistry();
        CqlIdentifier keyspace = statement2.getKeyspace();
        if (statement2 instanceof SimpleStatement) {
            SimpleStatement simpleStatement = (SimpleStatement)statement2;
            List<Object> positionalValues = simpleStatement.getPositionalValues();
            Map<CqlIdentifier, Object> namedValues = simpleStatement.getNamedValues();
            if (!positionalValues.isEmpty() && !namedValues.isEmpty()) {
                throw new IllegalArgumentException("Can't have both positional and named values in a statement.");
            }
            if (keyspace != null && !protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.PER_REQUEST_KEYSPACE)) {
                throw new IllegalArgumentException("Can't use per-request keyspace with protocol " + protocolVersion);
            }
            DseQueryOptions queryOptions = new DseQueryOptions(consistencyCode, Conversions.encode(positionalValues, codecRegistry, protocolVersion), Conversions.encode(namedValues, codecRegistry, protocolVersion), false, pageSize, statement2.getPagingState(), serialConsistencyCode, timestamp2, keyspace == null ? null : keyspace.asInternal(), pageSizeInBytes, options);
            return new Query(simpleStatement.getQuery(), queryOptions);
        }
        if (statement2 instanceof BoundStatement) {
            BoundStatement boundStatement = (BoundStatement)statement2;
            if (!protocolVersionRegistry.supports(protocolVersion, DefaultProtocolFeature.UNSET_BOUND_VALUES)) {
                Conversions.ensureAllSet(boundStatement);
            }
            boolean skipMetadata = boundStatement.getPreparedStatement().getResultSetDefinitions().size() > 0;
            DseQueryOptions queryOptions = new DseQueryOptions(consistencyCode, boundStatement.getValues(), Collections.emptyMap(), skipMetadata, pageSize, statement2.getPagingState(), serialConsistencyCode, timestamp2, null, pageSizeInBytes, options);
            PreparedStatement preparedStatement = boundStatement.getPreparedStatement();
            ByteBuffer id = preparedStatement.getId();
            ByteBuffer resultMetadataId = preparedStatement.getResultMetadataId();
            return new Execute(Bytes.getArray(id), resultMetadataId == null ? null : Bytes.getArray(resultMetadataId), queryOptions);
        }
        throw new IllegalArgumentException("Unsupported statement type: " + statement2.getClass().getName());
    }

    public static CoordinatorException toThrowable(Node node, Error errorMessage2, InternalDriverContext context) {
        switch (errorMessage2.code) {
            case 32768: {
                return new UnfitClientException(node, errorMessage2.message);
            }
        }
        return Conversions.toThrowable(node, errorMessage2, context);
    }
}

