/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.metrics;

import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;

public enum DseNodeMetric implements NodeMetric
{
    GRAPH_MESSAGES("graph-messages");

    private static final Map<String, DseNodeMetric> BY_PATH;
    private final String path;

    private DseNodeMetric(String path) {
        this.path = path;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public static DseNodeMetric fromPath(@NonNull String path) {
        DseNodeMetric metric = BY_PATH.get(path);
        if (metric == null) {
            throw new IllegalArgumentException("Unknown node metric path " + path);
        }
        return metric;
    }

    private static Map<String, DseNodeMetric> sortByPath() {
        ImmutableMap.Builder<String, DseNodeMetric> result2 = ImmutableMap.builder();
        for (DseNodeMetric value2 : DseNodeMetric.values()) {
            result2.put(value2.getPath(), value2);
        }
        return result2.build();
    }

    static {
        BY_PATH = DseNodeMetric.sortByPath();
    }
}

