/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Optional;

public interface DseFunctionMetadata
extends FunctionMetadata {
    @Deprecated
    public boolean isDeterministic();

    default public Optional<Boolean> getDeterministic() {
        return Optional.of(this.isDeterministic());
    }

    @Deprecated
    public boolean isMonotonic();

    default public Optional<Monotonicity> getMonotonicity() {
        return Optional.of(this.isMonotonic() ? Monotonicity.FULLY_MONOTONIC : (this.getMonotonicArgumentNames().isEmpty() ? Monotonicity.NOT_MONOTONIC : Monotonicity.PARTIALLY_MONOTONIC));
    }

    @NonNull
    public List<CqlIdentifier> getMonotonicArgumentNames();

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        builder.append("CREATE FUNCTION ").append(this.getKeyspace()).append(".").append(this.getSignature().getName()).append("(");
        boolean first = true;
        for (int i = 0; i < this.getSignature().getParameterTypes().size(); ++i) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            DataType type = this.getSignature().getParameterTypes().get(i);
            CqlIdentifier name2 = this.getParameterNames().get(i);
            builder.append(name2).append(" ").append(type.asCql(false, pretty));
        }
        builder.append(")").increaseIndent().newLine().append(this.isCalledOnNullInput() ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT").newLine().append("RETURNS ").append(this.getReturnType().asCql(false, true)).newLine();
        if (this.getDeterministic().orElse(false).booleanValue()) {
            builder.append("DETERMINISTIC").newLine();
        }
        if (this.getMonotonicity().isPresent()) {
            switch (this.getMonotonicity().get()) {
                case FULLY_MONOTONIC: {
                    builder.append("MONOTONIC").newLine();
                    break;
                }
                case PARTIALLY_MONOTONIC: {
                    builder.append("MONOTONIC ON ").append(this.getMonotonicArgumentNames().get(0)).newLine();
                    break;
                }
            }
        }
        builder.append("LANGUAGE ").append(this.getLanguage()).newLine().append("AS '").append(this.getBody()).append("';");
        return builder.build();
    }

    public static enum Monotonicity {
        FULLY_MONOTONIC,
        PARTIALLY_MONOTONIC,
        NOT_MONOTONIC;

    }
}

