/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.data.time;

import com.datastax.dse.driver.api.core.data.time.DateRangePrecision;
import com.datastax.dse.driver.internal.core.search.DateRangeUtil;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Objects;

public class DateRangeBound {
    public static final DateRangeBound UNBOUNDED = new DateRangeBound();
    @Nullable
    private final ZonedDateTime timestamp;
    @Nullable
    private final DateRangePrecision precision;

    @NonNull
    public static DateRangeBound parseLowerBound(@NonNull String source) throws ParseException {
        Preconditions.checkNotNull(source);
        Calendar calendar = DateRangeUtil.parseCalendar(source);
        DateRangePrecision precision = DateRangeUtil.getPrecision(calendar);
        return precision == null ? UNBOUNDED : DateRangeBound.lowerBound(DateRangeUtil.toZonedDateTime(calendar), precision);
    }

    public static DateRangeBound parseUpperBound(String source) throws ParseException {
        Preconditions.checkNotNull(source);
        Calendar calendar = DateRangeUtil.parseCalendar(source);
        DateRangePrecision precision = DateRangeUtil.getPrecision(calendar);
        return precision == null ? UNBOUNDED : DateRangeBound.upperBound(DateRangeUtil.toZonedDateTime(calendar), precision);
    }

    public static DateRangeBound lowerBound(ZonedDateTime timestamp2, DateRangePrecision precision) {
        return new DateRangeBound(precision.roundDown(timestamp2), precision);
    }

    public static DateRangeBound upperBound(ZonedDateTime timestamp2, DateRangePrecision precision) {
        return new DateRangeBound(precision.roundUp(timestamp2), precision);
    }

    private DateRangeBound(@NonNull ZonedDateTime timestamp2, @NonNull DateRangePrecision precision) {
        Preconditions.checkNotNull(timestamp2);
        Preconditions.checkNotNull(precision);
        this.timestamp = timestamp2;
        this.precision = precision;
    }

    private DateRangeBound() {
        this.timestamp = null;
        this.precision = null;
    }

    public boolean isUnbounded() {
        return this.timestamp == null && this.precision == null;
    }

    @NonNull
    public ZonedDateTime getTimestamp() {
        if (this.isUnbounded()) {
            throw new IllegalStateException("Can't call this method on UNBOUNDED, use isUnbounded() to check first");
        }
        assert (this.timestamp != null);
        return this.timestamp;
    }

    @NonNull
    public DateRangePrecision getPrecision() {
        if (this.isUnbounded()) {
            throw new IllegalStateException("Can't call this method on UNBOUNDED, use isUnbounded() to check first");
        }
        assert (this.precision != null);
        return this.precision;
    }

    @NonNull
    public String toString() {
        if (this.isUnbounded()) {
            return "*";
        }
        assert (this.timestamp != null && this.precision != null);
        return this.precision.format(this.timestamp);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DateRangeBound) {
            DateRangeBound that = (DateRangeBound)other;
            return Objects.equals(this.timestamp, that.timestamp) && Objects.equals((Object)this.precision, (Object)that.precision);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.precision});
    }
}

