/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.auth;

import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Map;

public class ProxyAuthentication {
    private static final String PROXY_EXECUTE = "ProxyExecute";

    @NonNull
    public static <StatementT extends Statement<StatementT>> StatementT executeAs(@NonNull String userOrRole, @NonNull StatementT statement2) {
        return statement2.setCustomPayload(ProxyAuthentication.addProxyExecuteEntry(statement2.getCustomPayload(), userOrRole));
    }

    @NonNull
    public static <StatementT extends GraphStatement<StatementT>> StatementT executeAs(@NonNull String userOrRole, @NonNull StatementT statement2) {
        return statement2.setCustomPayload(ProxyAuthentication.addProxyExecuteEntry(statement2.getCustomPayload(), userOrRole));
    }

    private static Map<String, ByteBuffer> addProxyExecuteEntry(Map<String, ByteBuffer> currentPayload, @NonNull String userOrRole) {
        NullAllowingImmutableMap.Builder<String, ByteBuffer> builder = NullAllowingImmutableMap.builder();
        builder.put(PROXY_EXECUTE, ByteBuffer.wrap(userOrRole.getBytes(Charsets.UTF_8)));
        if (!currentPayload.isEmpty()) {
            for (Map.Entry<String, ByteBuffer> entry2 : currentPayload.entrySet()) {
                String key = entry2.getKey();
                if (key.equals(PROXY_EXECUTE)) continue;
                builder.put(key, entry2.getValue());
            }
        }
        return builder.build();
    }
}

