/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvFileProvider;
import com.codahale.metrics.FixedNameCsvFileProvider;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReporter
extends ScheduledReporter {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvReporter.class);
    private final File directory;
    private final Locale locale;
    private final String separator;
    private final Clock clock;
    private final CsvFileProvider csvFileProvider;
    private final String histogramFormat;
    private final String meterFormat;
    private final String timerFormat;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private CsvReporter(MetricRegistry registry, File directory, Locale locale, String separator, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter2, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, CsvFileProvider csvFileProvider) {
        super(registry, "csv-reporter", filter2, rateUnit, durationUnit, executor, shutdownExecutorOnStop);
        this.directory = directory;
        this.locale = locale;
        this.separator = separator;
        this.clock = clock;
        this.csvFileProvider = csvFileProvider;
        this.histogramFormat = String.join((CharSequence)separator, "%d", "%d", "%f", "%d", "%f", "%f", "%f", "%f", "%f", "%f", "%f");
        this.meterFormat = String.join((CharSequence)separator, "%d", "%f", "%f", "%f", "%f", "events/%s");
        this.timerFormat = String.join((CharSequence)separator, "%d", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "%f", "calls/%s", "%s");
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp2 = TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
        for (Map.Entry<String, Gauge> entry2 : gauges.entrySet()) {
            this.reportGauge(timestamp2, entry2.getKey(), entry2.getValue());
        }
        for (Map.Entry<String, Metric> entry3 : counters.entrySet()) {
            this.reportCounter(timestamp2, entry3.getKey(), (Counter)entry3.getValue());
        }
        for (Map.Entry<String, Metric> entry4 : histograms.entrySet()) {
            this.reportHistogram(timestamp2, entry4.getKey(), (Histogram)entry4.getValue());
        }
        for (Map.Entry<String, Metric> entry5 : meters.entrySet()) {
            this.reportMeter(timestamp2, entry5.getKey(), (Meter)entry5.getValue());
        }
        for (Map.Entry<String, Metric> entry6 : timers.entrySet()) {
            this.reportTimer(timestamp2, entry6.getKey(), (Timer)entry6.getValue());
        }
    }

    private void reportTimer(long timestamp2, String name2, Timer timer) {
        Snapshot snapshot2 = timer.getSnapshot();
        this.report(timestamp2, name2, "count,max,mean,min,stddev,p50,p75,p95,p98,p99,p999,mean_rate,m1_rate,m5_rate,m15_rate,rate_unit,duration_unit", this.timerFormat, timer.getCount(), this.convertDuration(snapshot2.getMax()), this.convertDuration(snapshot2.getMean()), this.convertDuration(snapshot2.getMin()), this.convertDuration(snapshot2.getStdDev()), this.convertDuration(snapshot2.getMedian()), this.convertDuration(snapshot2.get75thPercentile()), this.convertDuration(snapshot2.get95thPercentile()), this.convertDuration(snapshot2.get98thPercentile()), this.convertDuration(snapshot2.get99thPercentile()), this.convertDuration(snapshot2.get999thPercentile()), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit(), this.getDurationUnit());
    }

    private void reportMeter(long timestamp2, String name2, Meter meter) {
        this.report(timestamp2, name2, "count,mean_rate,m1_rate,m5_rate,m15_rate,rate_unit", this.meterFormat, meter.getCount(), this.convertRate(meter.getMeanRate()), this.convertRate(meter.getOneMinuteRate()), this.convertRate(meter.getFiveMinuteRate()), this.convertRate(meter.getFifteenMinuteRate()), this.getRateUnit());
    }

    private void reportHistogram(long timestamp2, String name2, Histogram histogram) {
        Snapshot snapshot2 = histogram.getSnapshot();
        this.report(timestamp2, name2, "count,max,mean,min,stddev,p50,p75,p95,p98,p99,p999", this.histogramFormat, histogram.getCount(), snapshot2.getMax(), snapshot2.getMean(), snapshot2.getMin(), snapshot2.getStdDev(), snapshot2.getMedian(), snapshot2.get75thPercentile(), snapshot2.get95thPercentile(), snapshot2.get98thPercentile(), snapshot2.get99thPercentile(), snapshot2.get999thPercentile());
    }

    private void reportCounter(long timestamp2, String name2, Counter counter) {
        this.report(timestamp2, name2, "count", "%d", counter.getCount());
    }

    private void reportGauge(long timestamp2, String name2, Gauge<?> gauge) {
        this.report(timestamp2, name2, "value", "%s", gauge.getValue());
    }

    private void report(long timestamp2, String name2, String header2, String line, Object ... values2) {
        block14: {
            try {
                File file = this.csvFileProvider.getFile(this.directory, name2);
                boolean fileAlreadyExists = file.exists();
                if (!fileAlreadyExists && !file.createNewFile()) break block14;
                try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));){
                    if (!fileAlreadyExists) {
                        out.println("t," + header2);
                    }
                    out.printf(this.locale, String.format(this.locale, "%d" + this.separator + "%s%n", timestamp2, line), values2);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error writing to {}", (Object)name2, (Object)e);
            }
        }
    }

    protected String sanitize(String name2) {
        return name2;
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Locale locale;
        private String separator;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private CsvFileProvider csvFileProvider;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.locale = Locale.getDefault();
            this.separator = CsvReporter.DEFAULT_SEPARATOR;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
            this.csvFileProvider = new FixedNameCsvFileProvider();
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder formatFor(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder withSeparator(String separator) {
            this.separator = separator;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder filter(MetricFilter filter2) {
            this.filter = filter2;
            return this;
        }

        public Builder withCsvFileProvider(CsvFileProvider csvFileProvider) {
            this.csvFileProvider = csvFileProvider;
            return this;
        }

        public CsvReporter build(File directory) {
            return new CsvReporter(this.registry, directory, this.locale, this.separator, this.rateUnit, this.durationUnit, this.clock, this.filter, this.executor, this.shutdownExecutorOnStop, this.csvFileProvider);
        }
    }
}

