/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc.sorting;

import java.util.Comparator;

public interface IndirectComparator {
    public int compare(int var1, int var2);

    public static final class DelegatingComparator<T>
    implements IndirectComparator {
        private final T[] array;
        private final Comparator<? super T> delegate;

        public DelegatingComparator(T[] array2, Comparator<? super T> delegate) {
            this.array = array2;
            this.delegate = delegate;
        }

        @Override
        public final int compare(int indexA, int indexB) {
            return this.delegate.compare(this.array[indexA], this.array[indexB]);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " -> " + this.delegate;
        }
    }

    public static class DescendingFloatComparator
    extends AscendingFloatComparator {
        public DescendingFloatComparator(float[] array2) {
            super(array2);
        }

        @Override
        public final int compare(int indexA, int indexB) {
            return -super.compare(indexA, indexB);
        }
    }

    public static class AscendingFloatComparator
    implements IndirectComparator {
        private final float[] array;

        public AscendingFloatComparator(float[] array2) {
            this.array = array2;
        }

        @Override
        public int compare(int indexA, int indexB) {
            float a = this.array[indexA];
            float b = this.array[indexB];
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    public static class DescendingDoubleComparator
    extends AscendingDoubleComparator {
        public DescendingDoubleComparator(double[] array2) {
            super(array2);
        }

        @Override
        public final int compare(int indexA, int indexB) {
            return -super.compare(indexA, indexB);
        }
    }

    public static class AscendingDoubleComparator
    implements IndirectComparator {
        private final double[] array;

        public AscendingDoubleComparator(double[] array2) {
            this.array = array2;
        }

        @Override
        public int compare(int indexA, int indexB) {
            double a = this.array[indexA];
            double b = this.array[indexB];
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    public static class DescendingShortComparator
    extends AscendingShortComparator {
        public DescendingShortComparator(short[] array2) {
            super(array2);
        }

        @Override
        public final int compare(int indexA, int indexB) {
            return -super.compare(indexA, indexB);
        }
    }

    public static class AscendingShortComparator
    implements IndirectComparator {
        private final short[] array;

        public AscendingShortComparator(short[] array2) {
            this.array = array2;
        }

        @Override
        public int compare(int indexA, int indexB) {
            short a = this.array[indexA];
            short b = this.array[indexB];
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }

    public static class DescendingIntComparator
    extends AscendingIntComparator {
        public DescendingIntComparator(int[] array2) {
            super(array2);
        }

        @Override
        public final int compare(int indexA, int indexB) {
            return -super.compare(indexA, indexB);
        }
    }

    public static class AscendingIntComparator
    implements IndirectComparator {
        private final int[] array;

        public AscendingIntComparator(int[] array2) {
            this.array = array2;
        }

        @Override
        public int compare(int indexA, int indexB) {
            int a = this.array[indexA];
            int b = this.array[indexB];
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
    }
}

